/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.m;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.a;

public abstract class TFIDFSimilarity
extends a {
    public abstract float tf(float var1);

    public Explanation idfExplain(CollectionStatistics collectionStatistics, TermStatistics termStatistics) {
        long l2 = termStatistics.docFreq();
        long l3 = collectionStatistics.maxDoc();
        float f2 = this.idf(l2, l3);
        return Explanation.match(f2, "idf(docFreq=" + l2 + ", maxDocs=" + l3 + ")", new Explanation[0]);
    }

    public Explanation idfExplain(CollectionStatistics collectionStatistics, TermStatistics[] termStatisticsArray) {
        long l2 = collectionStatistics.maxDoc();
        float f2 = 0.0f;
        ArrayList<Explanation> arrayList = new ArrayList<Explanation>();
        for (TermStatistics termStatistics : termStatisticsArray) {
            long l3 = termStatistics.docFreq();
            float f3 = this.idf(l3, l2);
            arrayList.add(Explanation.match(f3, "idf(docFreq=" + l3 + ", maxDocs=" + l2 + ")", new Explanation[0]));
            f2 += f3;
        }
        return Explanation.match(f2, "idf(), sum of:", arrayList);
    }

    public abstract float idf(long var1, long var3);

    public abstract float lengthNorm(FieldInvertState var1);

    @Override
    public final long computeNorm(FieldInvertState fieldInvertState) {
        float f2 = this.lengthNorm(fieldInvertState);
        return this.encodeNormValue(f2);
    }

    public abstract float decodeNormValue(long var1);

    public abstract long encodeNormValue(float var1);

    public abstract float sloppyFreq(int var1);

    @Override
    public final a.b computeWeight(float f2, CollectionStatistics collectionStatistics, TermStatistics ... termStatisticsArray) {
        Explanation explanation = termStatisticsArray.length == 1 ? this.idfExplain(collectionStatistics, termStatisticsArray[0]) : this.idfExplain(collectionStatistics, termStatisticsArray);
        return new IDFStats(collectionStatistics.field(), explanation, f2);
    }

    @Override
    public final a.a simScorer(a.b b2, LeafReaderContext leafReaderContext) throws IOException {
        IDFStats iDFStats = (IDFStats)b2;
        return new TFIDFSimScorer(iDFStats, leafReaderContext.reader().getNormValues(iDFStats.field));
    }

    private static class IDFStats
    extends a.b {
        private final String field;
        private final Explanation idf;
        private float queryNorm;
        private float queryWeight;
        private final float queryBoost;
        private float value;

        public IDFStats(String string, Explanation explanation, float f2) {
            this.field = string;
            this.idf = explanation;
            this.queryBoost = f2;
            this.queryWeight = explanation.getValue() * f2;
        }

        @Override
        public float getValueForNormalization() {
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float f2, float f3) {
            this.queryNorm = f2 * f3;
            this.queryWeight *= this.queryNorm;
            this.value = this.queryWeight * this.idf.getValue();
        }
    }

    private final class TFIDFSimScorer
    extends a.a {
        private final IDFStats stats;
        private final float weightValue;
        private final m norms;

        TFIDFSimScorer(IDFStats iDFStats, m m2) throws IOException {
            this.stats = iDFStats;
            this.weightValue = iDFStats.value;
            this.norms = m2;
        }

        @Override
        public float score(int n2, float f2) {
            float f3 = TFIDFSimilarity.this.tf(f2) * this.weightValue;
            return this.norms == null ? f3 : f3 * TFIDFSimilarity.this.decodeNormValue(this.norms.get(n2));
        }

        @Override
        public float computeSlopFactor(int n2) {
            return TFIDFSimilarity.this.sloppyFreq(n2);
        }
    }
}

