/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.b;

public class BufferedChecksumIndexInput
extends b {
    final IndexInput main;
    final Checksum digest;

    public BufferedChecksumIndexInput(IndexInput indexInput) {
        super("BufferedChecksumIndexInput(" + indexInput + ")");
        this.main = indexInput;
        this.digest = new BufferedChecksum(new CRC32());
    }

    @Override
    public byte readByte() throws IOException {
        byte by = this.main.readByte();
        this.digest.update(by);
        return by;
    }

    @Override
    public void readBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.main.readBytes(byArray, n2, n3);
        this.digest.update(byArray, n2, n3);
    }

    @Override
    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public void close() throws IOException {
        this.main.close();
    }

    @Override
    public long getFilePointer() {
        return this.main.getFilePointer();
    }

    @Override
    public long length() {
        return this.main.length();
    }

    @Override
    public IndexInput clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexInput slice(String string, long l2, long l3) throws IOException {
        throw new UnsupportedOperationException();
    }
}

