/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.h;
import org.apache.lucene.util.WeakIdentityMap;

abstract class ByteBufferIndexInput
extends IndexInput
implements h {
    protected final a cleaner;
    protected final long length;
    protected final long chunkSizeMask;
    protected final int chunkSizePower;
    protected ByteBuffer[] buffers;
    protected int curBufIndex = -1;
    protected ByteBuffer curBuf;
    protected boolean isClone = false;
    protected final WeakIdentityMap<ByteBufferIndexInput, Boolean> clones;

    public static ByteBufferIndexInput newInstance(String string, ByteBuffer[] byteBufferArray, long l2, int n2, a a2, boolean bl) {
        WeakIdentityMap<ByteBufferIndexInput, Boolean> weakIdentityMap;
        WeakIdentityMap<ByteBufferIndexInput, Boolean> weakIdentityMap2 = weakIdentityMap = bl ? WeakIdentityMap.newConcurrentHashMap() : null;
        if (byteBufferArray.length == 1) {
            return new b(string, byteBufferArray[0], l2, n2, a2, weakIdentityMap);
        }
        return new MultiBufferImpl(string, byteBufferArray, 0, l2, n2, a2, weakIdentityMap);
    }

    ByteBufferIndexInput(String string, ByteBuffer[] byteBufferArray, long l2, int n2, a a2, WeakIdentityMap<ByteBufferIndexInput, Boolean> weakIdentityMap) {
        super(string);
        this.buffers = byteBufferArray;
        this.length = l2;
        this.chunkSizePower = n2;
        this.chunkSizeMask = (1L << n2) - 1L;
        this.clones = weakIdentityMap;
        this.cleaner = a2;
        assert (n2 >= 0 && n2 <= 30);
        assert (l2 >>> n2 < Integer.MAX_VALUE);
    }

    @Override
    public final byte readByte() throws IOException {
        try {
            return this.curBuf.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            do {
                ++this.curBufIndex;
                if (this.curBufIndex >= this.buffers.length) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.curBuf = this.buffers[this.curBufIndex];
                this.curBuf.position(0);
            } while (!this.curBuf.hasRemaining());
            return this.curBuf.get();
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    @Override
    public final void readBytes(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.curBuf.get(byArray, n2, n3);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            int n4 = this.curBuf.remaining();
            while (n3 > n4) {
                this.curBuf.get(byArray, n2, n4);
                n3 -= n4;
                n2 += n4;
                ++this.curBufIndex;
                if (this.curBufIndex >= this.buffers.length) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.curBuf = this.buffers[this.curBufIndex];
                this.curBuf.position(0);
                n4 = this.curBuf.remaining();
            }
            this.curBuf.get(byArray, n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    @Override
    public final short readShort() throws IOException {
        try {
            return this.curBuf.getShort();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return super.readShort();
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    @Override
    public final int readInt() throws IOException {
        try {
            return this.curBuf.getInt();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return super.readInt();
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    @Override
    public final long readLong() throws IOException {
        try {
            return this.curBuf.getLong();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return super.readLong();
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    @Override
    public long getFilePointer() {
        try {
            return ((long)this.curBufIndex << this.chunkSizePower) + (long)this.curBuf.position();
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    @Override
    public void seek(long l2) throws IOException {
        int n2 = (int)(l2 >> this.chunkSizePower);
        try {
            if (n2 == this.curBufIndex) {
                this.curBuf.position((int)(l2 & this.chunkSizeMask));
            } else {
                ByteBuffer byteBuffer = this.buffers[n2];
                byteBuffer.position((int)(l2 & this.chunkSizeMask));
                this.curBufIndex = n2;
                this.curBuf = byteBuffer;
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException runtimeException) {
            throw new EOFException("seek past EOF: " + this);
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    @Override
    public byte readByte(long l2) throws IOException {
        try {
            int n2 = (int)(l2 >> this.chunkSizePower);
            return this.buffers[n2].get((int)(l2 & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new EOFException("seek past EOF: " + this);
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    private void setPos(long l2, int n2) throws IOException {
        try {
            ByteBuffer byteBuffer = this.buffers[n2];
            byteBuffer.position((int)(l2 & this.chunkSizeMask));
            this.curBufIndex = n2;
            this.curBuf = byteBuffer;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException runtimeException) {
            throw new EOFException("seek past EOF: " + this);
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    @Override
    public short readShort(long l2) throws IOException {
        int n2 = (int)(l2 >> this.chunkSizePower);
        try {
            return this.buffers[n2].getShort((int)(l2 & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.setPos(l2, n2);
            return this.readShort();
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    @Override
    public int readInt(long l2) throws IOException {
        int n2 = (int)(l2 >> this.chunkSizePower);
        try {
            return this.buffers[n2].getInt((int)(l2 & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.setPos(l2, n2);
            return this.readInt();
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    @Override
    public long readLong(long l2) throws IOException {
        int n2 = (int)(l2 >> this.chunkSizePower);
        try {
            return this.buffers[n2].getLong((int)(l2 & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.setPos(l2, n2);
            return this.readLong();
        }
        catch (NullPointerException nullPointerException) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
    }

    @Override
    public final long length() {
        return this.length;
    }

    @Override
    public final ByteBufferIndexInput clone() {
        ByteBufferIndexInput byteBufferIndexInput = this.buildSlice((String)null, 0L, this.length);
        try {
            byteBufferIndexInput.seek(this.getFilePointer());
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return byteBufferIndexInput;
    }

    @Override
    public final ByteBufferIndexInput slice(String string, long l2, long l3) {
        if (l2 < 0L || l3 < 0L || l2 + l3 > this.length) {
            throw new IllegalArgumentException("slice() " + string + " out of bounds: offset=" + l2 + ",length=" + l3 + ",fileLength=" + this.length + ": " + this);
        }
        return this.buildSlice(string, l2, l3);
    }

    protected ByteBufferIndexInput buildSlice(String string, long l2, long l3) {
        if (this.buffers == null) {
            throw new org.apache.lucene.store.a("Already closed: " + this);
        }
        ByteBuffer[] byteBufferArray = this.buildSlice(this.buffers, l2, l3);
        int n2 = (int)(l2 & this.chunkSizeMask);
        ByteBufferIndexInput byteBufferIndexInput = this.newCloneInstance(this.getFullSliceDescription(string), byteBufferArray, n2, l3);
        byteBufferIndexInput.isClone = true;
        if (this.clones != null) {
            this.clones.put(byteBufferIndexInput, Boolean.TRUE);
        }
        return byteBufferIndexInput;
    }

    protected ByteBufferIndexInput newCloneInstance(String string, ByteBuffer[] byteBufferArray, int n2, long l2) {
        if (byteBufferArray.length == 1) {
            byteBufferArray[0].position(n2);
            return new b(string, byteBufferArray[0].slice(), l2, this.chunkSizePower, this.cleaner, this.clones);
        }
        return new MultiBufferImpl(string, byteBufferArray, n2, l2, this.chunkSizePower, this.cleaner, this.clones);
    }

    private ByteBuffer[] buildSlice(ByteBuffer[] byteBufferArray, long l2, long l3) {
        long l4 = l2 + l3;
        int n2 = (int)(l2 >>> this.chunkSizePower);
        int n3 = (int)(l4 >>> this.chunkSizePower);
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3 - n2 + 1];
        for (int i2 = 0; i2 < byteBufferArray2.length; ++i2) {
            byteBufferArray2[i2] = byteBufferArray[n2 + i2].duplicate();
        }
        byteBufferArray2[byteBufferArray2.length - 1].limit((int)(l4 & this.chunkSizeMask));
        return byteBufferArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        try {
            if (this.buffers == null) {
                return;
            }
            ByteBuffer[] byteBufferArray = this.buffers;
            this.unsetBuffers();
            if (this.clones != null) {
                this.clones.remove(this);
            }
            if (this.isClone) {
                return;
            }
            if (this.clones != null) {
                Iterator<ByteBufferIndexInput> iterator = this.clones.keyIterator();
                while (iterator.hasNext()) {
                    ByteBufferIndexInput byteBufferIndexInput = (ByteBufferIndexInput)iterator.next();
                    assert (byteBufferIndexInput.isClone);
                    byteBufferIndexInput.unsetBuffers();
                }
                this.clones.clear();
            }
            for (ByteBuffer byteBuffer : byteBufferArray) {
                this.freeBuffer(byteBuffer);
            }
        }
        finally {
            this.unsetBuffers();
        }
    }

    private void unsetBuffers() {
        this.buffers = null;
        this.curBuf = null;
        this.curBufIndex = 0;
    }

    private void freeBuffer(ByteBuffer byteBuffer) throws IOException {
        if (this.cleaner != null) {
            this.cleaner.a(this, byteBuffer);
        }
    }

    static final class MultiBufferImpl
    extends ByteBufferIndexInput {
        private final int offset;

        MultiBufferImpl(String string, ByteBuffer[] byteBufferArray, int n2, long l2, int n3, a a2, WeakIdentityMap<ByteBufferIndexInput, Boolean> weakIdentityMap) {
            super(string, byteBufferArray, l2, n3, a2, weakIdentityMap);
            this.offset = n2;
            try {
                this.seek(0L);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void seek(long l2) throws IOException {
            assert (l2 >= 0L);
            super.seek(l2 + (long)this.offset);
        }

        @Override
        public long getFilePointer() {
            return super.getFilePointer() - (long)this.offset;
        }

        @Override
        public byte readByte(long l2) throws IOException {
            return super.readByte(l2 + (long)this.offset);
        }

        @Override
        public short readShort(long l2) throws IOException {
            return super.readShort(l2 + (long)this.offset);
        }

        @Override
        public int readInt(long l2) throws IOException {
            return super.readInt(l2 + (long)this.offset);
        }

        @Override
        public long readLong(long l2) throws IOException {
            return super.readLong(l2 + (long)this.offset);
        }

        @Override
        protected ByteBufferIndexInput buildSlice(String string, long l2, long l3) {
            return super.buildSlice(string, (long)this.offset + l2, l3);
        }
    }

    static final class b
    extends ByteBufferIndexInput {
        b(String string, ByteBuffer byteBuffer, long l2, int n2, a a2, WeakIdentityMap<ByteBufferIndexInput, Boolean> weakIdentityMap) {
            super(string, new ByteBuffer[]{byteBuffer}, l2, n2, a2, weakIdentityMap);
            this.curBufIndex = 0;
            this.curBuf = byteBuffer;
            byteBuffer.position(0);
        }

        @Override
        public void seek(long l2) throws IOException {
            try {
                this.curBuf.position((int)l2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (l2 < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, illegalArgumentException);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException nullPointerException) {
                throw new org.apache.lucene.store.a("Already closed: " + this);
            }
        }

        @Override
        public long getFilePointer() {
            try {
                return this.curBuf.position();
            }
            catch (NullPointerException nullPointerException) {
                throw new org.apache.lucene.store.a("Already closed: " + this);
            }
        }

        @Override
        public byte readByte(long l2) throws IOException {
            try {
                return this.curBuf.get((int)l2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (l2 < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, illegalArgumentException);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException nullPointerException) {
                throw new org.apache.lucene.store.a("Already closed: " + this);
            }
        }

        @Override
        public short readShort(long l2) throws IOException {
            try {
                return this.curBuf.getShort((int)l2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (l2 < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, illegalArgumentException);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException nullPointerException) {
                throw new org.apache.lucene.store.a("Already closed: " + this);
            }
        }

        @Override
        public int readInt(long l2) throws IOException {
            try {
                return this.curBuf.getInt((int)l2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (l2 < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, illegalArgumentException);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException nullPointerException) {
                throw new org.apache.lucene.store.a("Already closed: " + this);
            }
        }

        @Override
        public long readLong(long l2) throws IOException {
            try {
                return this.curBuf.getLong((int)l2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (l2 < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, illegalArgumentException);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException nullPointerException) {
                throw new org.apache.lucene.store.a("Already closed: " + this);
            }
        }
    }

    static interface a {
        public void a(ByteBufferIndexInput var1, ByteBuffer var2) throws IOException;
    }
}

