/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.portmobile.file.AtomicMoveNotSupportedException;
import org.apache.lucene.portmobile.file.NoSuchFileException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.c;
import org.apache.lucene.store.e;
import org.apache.lucene.util.IOUtils;

public class FileSwitchDirectory
extends c {
    private final c secondaryDir;
    private final c primaryDir;
    private final Set<String> primaryExtensions;
    private boolean doClose;

    public c getPrimaryDir() {
        return this.primaryDir;
    }

    public c getSecondaryDir() {
        return this.secondaryDir;
    }

    @Override
    public e obtainLock(String string) throws IOException {
        return this.getDirectory(string).obtainLock(string);
    }

    @Override
    public void close() throws IOException {
        if (this.doClose) {
            IOUtils.close(this.primaryDir, this.secondaryDir);
            this.doClose = false;
        }
    }

    @Override
    public String[] listAll() throws IOException {
        NoSuchFileException noSuchFileException;
        HashSet<String> hashSet;
        block8: {
            hashSet = new HashSet<String>();
            noSuchFileException = null;
            try {
                for (String string : this.primaryDir.listAll()) {
                    hashSet.add(string);
                }
            }
            catch (NoSuchFileException noSuchFileException2) {
                noSuchFileException = noSuchFileException2;
            }
            try {
                for (String string : this.secondaryDir.listAll()) {
                    hashSet.add(string);
                }
            }
            catch (NoSuchFileException noSuchFileException3) {
                if (noSuchFileException != null) {
                    throw noSuchFileException;
                }
                if (!hashSet.isEmpty()) break block8;
                throw noSuchFileException3;
            }
        }
        if (noSuchFileException != null && hashSet.isEmpty()) {
            throw noSuchFileException;
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static String getExtension(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return "";
        }
        return string.substring(n2 + 1, string.length());
    }

    private c getDirectory(String string) {
        String string2 = FileSwitchDirectory.getExtension(string);
        if (this.primaryExtensions.contains(string2)) {
            return this.primaryDir;
        }
        return this.secondaryDir;
    }

    @Override
    public void deleteFile(String string) throws IOException {
        this.getDirectory(string).deleteFile(string);
    }

    @Override
    public long fileLength(String string) throws IOException {
        return this.getDirectory(string).fileLength(string);
    }

    @Override
    public IndexOutput createOutput(String string, IOContext iOContext) throws IOException {
        return this.getDirectory(string).createOutput(string, iOContext);
    }

    @Override
    public void sync(Collection<String> collection) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : collection) {
            if (this.primaryExtensions.contains(FileSwitchDirectory.getExtension(string))) {
                arrayList.add(string);
                continue;
            }
            arrayList2.add(string);
        }
        this.primaryDir.sync(arrayList);
        this.secondaryDir.sync(arrayList2);
    }

    @Override
    public void renameFile(String string, String string2) throws IOException {
        c c2 = this.getDirectory(string);
        if (c2 != this.getDirectory(string2)) {
            throw new AtomicMoveNotSupportedException(string, string2, "source and dest are in different directories");
        }
        c2.renameFile(string, string2);
    }

    @Override
    public IndexInput openInput(String string, IOContext iOContext) throws IOException {
        return this.getDirectory(string).openInput(string, iOContext);
    }
}

