/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

public class FlushInfo {
    public final int numDocs;
    public final long estimatedSegmentSize;

    public FlushInfo(int n2, long l2) {
        this.numDocs = n2;
        this.estimatedSegmentSize = l2;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (int)(this.estimatedSegmentSize ^ this.estimatedSegmentSize >>> 32);
        n3 = 31 * n3 + this.numDocs;
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FlushInfo flushInfo = (FlushInfo)object;
        if (this.estimatedSegmentSize != flushInfo.estimatedSegmentSize) {
            return false;
        }
        return this.numDocs == flushInfo.numDocs;
    }

    public String toString() {
        return "FlushInfo [numDocs=" + this.numDocs + ", estimatedSegmentSize=" + this.estimatedSegmentSize + "]";
    }
}

