/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.portmobile.file.Files;
import org.apache.lucene.portmobile.file.Path;
import org.apache.lucene.portmobile.file.StandardOpenOption;
import org.apache.lucene.portmobile.file.attribute.BasicFileAttributes;
import org.apache.lucene.portmobile.file.attribute.FileTime;
import org.apache.lucene.portmobile.util.FileChannelUtils;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.a;
import org.apache.lucene.store.d;
import org.apache.lucene.store.e;
import org.apache.lucene.store.g;
import org.apache.lucene.util.IOUtils;

public final class NativeFSLockFactory
extends d {
    public static final NativeFSLockFactory INSTANCE = new NativeFSLockFactory();
    private static final Set<String> LOCK_HELD = Collections.synchronizedSet(new HashSet());

    private NativeFSLockFactory() {
    }

    @Override
    protected e obtainFSLock(FSDirectory fSDirectory, String string) throws IOException {
        Path path = fSDirectory.getDirectory();
        Files.createDirectories(path);
        Path path2 = path.resolve(string);
        try {
            Files.createFile(path2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path path3 = path2.toRealPath();
        FileTime fileTime = Files.readAttributes(path3, BasicFileAttributes.class).creationTime();
        if (LOCK_HELD.add(path3.toString())) {
            block7: {
                NativeFSLock nativeFSLock;
                block8: {
                    FileChannel fileChannel = null;
                    FileLock fileLock = null;
                    try {
                        fileChannel = FileChannelUtils.open(path3, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                        fileLock = fileChannel.tryLock();
                        if (fileLock == null) break block7;
                        nativeFSLock = new NativeFSLock(fileLock, fileChannel, path3, fileTime);
                        if (fileLock != null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (fileLock == null) {
                            IOUtils.closeWhileHandlingException(fileChannel);
                            NativeFSLockFactory.clearLockHeld(path3);
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException(fileChannel);
                    NativeFSLockFactory.clearLockHeld(path3);
                }
                return nativeFSLock;
            }
            throw new g("Lock held by another program: " + path3);
        }
        throw new g("Lock held by this virtual machine: " + path3);
    }

    private static final void clearLockHeld(Path path) throws IOException {
        boolean bl = LOCK_HELD.remove(path.toString());
        if (!bl) {
            throw new a("Lock path was cleared but never marked as held: " + path);
        }
    }

    static final class NativeFSLock
    extends e {
        final FileLock lock;
        final FileChannel channel;
        final Path path;
        final FileTime creationTime;
        volatile boolean closed;

        NativeFSLock(FileLock fileLock, FileChannel fileChannel, Path path, FileTime fileTime) {
            this.lock = fileLock;
            this.channel = fileChannel;
            this.path = path;
            this.creationTime = fileTime;
        }

        @Override
        public void ensureValid() throws IOException {
            if (this.closed) {
                throw new a("Lock instance already released: " + this);
            }
            if (!LOCK_HELD.contains(this.path.toString())) {
                throw new a("Lock path unexpectedly cleared from map: " + this);
            }
            if (!this.lock.isValid()) {
                throw new a("FileLock invalidated by an external force: " + this);
            }
            long l2 = this.channel.size();
            if (l2 != 0L) {
                throw new a("Unexpected lock file size: " + l2 + ", (lock=" + this + ")");
            }
            FileTime fileTime = Files.readAttributes(this.path, BasicFileAttributes.class).creationTime();
            if (!this.creationTime.equals(fileTime)) {
                throw new a("Underlying file changed by an external force at " + this.creationTime + ", (lock=" + this + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try (FileChannel fileChannel = this.channel;){
                assert (this.lock != null);
                assert (fileChannel != null);
                this.lock.release();
            }
            finally {
                this.closed = true;
                NativeFSLockFactory.clearLockHeld(this.path);
            }
        }

        public String toString() {
            return "NativeFSLock(path=" + this.path + ",impl=" + this.lock + ",ctime=" + this.creationTime + ")";
        }
    }
}

