/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RAMFile;

public class RAMInputStream
extends IndexInput
implements Cloneable {
    private final RAMFile file;
    private final long length;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;

    public RAMInputStream(String string, RAMFile rAMFile) throws IOException {
        this(string, rAMFile, rAMFile.length);
    }

    RAMInputStream(String string, RAMFile rAMFile, long l2) throws IOException {
        super("RAMInputStream(name=" + string + ")");
        this.file = rAMFile;
        this.length = l2;
        if (l2 / 1024L >= Integer.MAX_VALUE) {
            throw new IOException("RAMInputStream too large length=" + l2 + ": " + string);
        }
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
    }

    @Override
    public void close() {
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer(true);
        }
        return this.currentBuffer[this.bufferPosition++];
    }

    @Override
    public void readBytes(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4;
            if (this.bufferPosition >= this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer(true);
            }
            int n5 = n3 < (n4 = this.bufferLength - this.bufferPosition) ? n3 : n4;
            System.arraycopy(this.currentBuffer, this.bufferPosition, byArray, n2, n5);
            n2 += n5;
            n3 -= n5;
            this.bufferPosition += n5;
        }
    }

    private final void switchCurrentBuffer(boolean bl) throws IOException {
        this.bufferStart = 1024L * (long)this.currentBufferIndex;
        if (this.bufferStart > this.length || this.currentBufferIndex >= this.file.numBuffers()) {
            if (bl) {
                throw new EOFException("read past EOF: " + this);
            }
            --this.currentBufferIndex;
            this.bufferPosition = 1024;
        } else {
            this.currentBuffer = this.file.getBuffer(this.currentBufferIndex);
            this.bufferPosition = 0;
            long l2 = this.length - this.bufferStart;
            this.bufferLength = l2 > 1024L ? 1024 : (int)l2;
        }
    }

    @Override
    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }

    @Override
    public void seek(long l2) throws IOException {
        if (this.currentBuffer == null || l2 < this.bufferStart || l2 >= this.bufferStart + 1024L) {
            this.currentBufferIndex = (int)(l2 / 1024L);
            this.switchCurrentBuffer(false);
        }
        this.bufferPosition = (int)(l2 % 1024L);
    }

    @Override
    public IndexInput slice(String string, final long l2, long l3) throws IOException {
        if (l2 < 0L || l3 < 0L || l2 + l3 > this.length) {
            throw new IllegalArgumentException("slice() " + string + " out of bounds: " + this);
        }
        return new RAMInputStream(this.getFullSliceDescription(string), this.file, l2 + l3){
            {
                super(string, rAMFile, l22);
                this.seek(0L);
            }

            @Override
            public void seek(long l22) throws IOException {
                if (l22 < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this);
                }
                super.seek(l22 + l2);
            }

            @Override
            public long getFilePointer() {
                return super.getFilePointer() - l2;
            }

            @Override
            public long length() {
                return super.length() - l2;
            }

            @Override
            public IndexInput slice(String string, long l22, long l3) throws IOException {
                return super.slice(string, l2 + l22, l3);
            }
        };
    }
}

