/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.c;

public final class TrackingDirectoryWrapper
extends FilterDirectory {
    private final Set<String> createdFileNames = Collections.synchronizedSet(new HashSet());

    public TrackingDirectoryWrapper(c c2) {
        super(c2);
    }

    @Override
    public void deleteFile(String string) throws IOException {
        this.in.deleteFile(string);
        this.createdFileNames.remove(string);
    }

    @Override
    public IndexOutput createOutput(String string, IOContext iOContext) throws IOException {
        IndexOutput indexOutput = this.in.createOutput(string, iOContext);
        this.createdFileNames.add(string);
        return indexOutput;
    }

    @Override
    public void copyFrom(c c2, String string, String string2, IOContext iOContext) throws IOException {
        this.in.copyFrom(c2, string, string2, iOContext);
        this.createdFileNames.add(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(String string, String string2) throws IOException {
        this.in.renameFile(string, string2);
        Set<String> set = this.createdFileNames;
        synchronized (set) {
            this.createdFileNames.add(string2);
            this.createdFileNames.remove(string);
        }
    }

    public Set<String> getCreatedFiles() {
        return this.createdFileNames;
    }
}

