/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Comparator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.TimSorter;

final class ArrayTimSorter<T>
extends TimSorter {
    private final Comparator<? super T> comparator;
    private final T[] arr;
    private final T[] tmp;

    public ArrayTimSorter(T[] TArray, Comparator<? super T> comparator, int n2) {
        super(n2);
        this.arr = TArray;
        this.comparator = comparator;
        if (n2 > 0) {
            Object[] objectArray = new Object[n2];
            this.tmp = objectArray;
        } else {
            this.tmp = null;
        }
    }

    @Override
    protected int compare(int n2, int n3) {
        return this.comparator.compare(this.arr[n2], this.arr[n3]);
    }

    @Override
    protected void swap(int n2, int n3) {
        ArrayUtil.swap(this.arr, n2, n3);
    }

    @Override
    protected void copy(int n2, int n3) {
        this.arr[n3] = this.arr[n2];
    }

    @Override
    protected void save(int n2, int n3) {
        System.arraycopy(this.arr, n2, this.tmp, 0, n3);
    }

    @Override
    protected void restore(int n2, int n3) {
        this.arr[n3] = this.tmp[n2];
    }

    @Override
    protected int compareSaved(int n2, int n3) {
        return this.comparator.compare(this.tmp[n2], this.arr[n3]);
    }
}

