/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.portmobile.invoke.MethodHandle;
import org.apache.lucene.portmobile.invoke.MethodHandles;
import org.apache.lucene.portmobile.invoke.MethodType;
import org.apache.lucene.portmobile.lang.ClassValue;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.c;

public abstract class AttributeFactory {
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private static final MethodType NO_ARG_CTOR = MethodType.methodType(Void.TYPE);
    private static final MethodType NO_ARG_RETURNING_ATTRIBUTEIMPL = MethodType.methodType(AttributeImpl.class);
    public static final AttributeFactory DEFAULT_ATTRIBUTE_FACTORY = new DefaultAttributeFactory();

    public abstract AttributeImpl createAttributeInstance(Class<? extends c> var1);

    static final MethodHandle findAttributeImplCtor(Class<? extends AttributeImpl> clazz) {
        try {
            return lookup.findConstructor(clazz, NO_ARG_CTOR).asType(NO_ARG_RETURNING_ATTRIBUTEIMPL);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new IllegalArgumentException("Cannot lookup accessible no-arg constructor for: " + clazz.getName(), reflectiveOperationException);
        }
    }

    public static <A extends AttributeImpl> AttributeFactory getStaticImplementation(AttributeFactory attributeFactory, Class<A> clazz) {
        final MethodHandle methodHandle = AttributeFactory.findAttributeImplCtor(clazz);
        return new StaticImplementationAttributeFactory<A>(attributeFactory, clazz){

            @Override
            protected A createInstance() {
                try {
                    return (AttributeImpl)methodHandle.invokeExact();
                }
                catch (Throwable throwable) {
                    1.rethrow(throwable);
                    throw new AssertionError();
                }
            }
        };
    }

    static void rethrow(Throwable throwable) {
        AttributeFactory.rethrow0(throwable);
    }

    private static <T extends Throwable> void rethrow0(Throwable throwable) throws T {
        throw throwable;
    }

    public static abstract class StaticImplementationAttributeFactory<A extends AttributeImpl>
    extends AttributeFactory {
        private final AttributeFactory delegate;
        private final Class<A> clazz;

        public StaticImplementationAttributeFactory(AttributeFactory attributeFactory, Class<A> clazz) {
            this.delegate = attributeFactory;
            this.clazz = clazz;
        }

        @Override
        public final AttributeImpl createAttributeInstance(Class<? extends c> clazz) {
            return clazz.isAssignableFrom(this.clazz) ? this.createInstance() : this.delegate.createAttributeInstance(clazz);
        }

        protected abstract A createInstance();

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            StaticImplementationAttributeFactory staticImplementationAttributeFactory = (StaticImplementationAttributeFactory)object;
            return this.delegate.equals(staticImplementationAttributeFactory.delegate) && this.clazz == staticImplementationAttributeFactory.clazz;
        }

        public int hashCode() {
            return 31 * this.delegate.hashCode() + this.clazz.hashCode();
        }
    }

    private static final class DefaultAttributeFactory
    extends AttributeFactory {
        private final ClassValue<MethodHandle> constructors = new ClassValue<MethodHandle>(){

            @Override
            protected MethodHandle computeValue(Class<?> clazz) {
                return AttributeFactory.findAttributeImplCtor(this.findImplClass(clazz.asSubclass(c.class)));
            }
        };

        DefaultAttributeFactory() {
        }

        @Override
        public AttributeImpl createAttributeInstance(Class<? extends c> clazz) {
            try {
                return (AttributeImpl)this.constructors.get(clazz).invokeExact();
            }
            catch (Throwable throwable) {
                DefaultAttributeFactory.rethrow(throwable);
                throw new AssertionError();
            }
        }

        private Class<? extends AttributeImpl> findImplClass(Class<? extends c> clazz) {
            try {
                return Class.forName(clazz.getName() + "Impl", true, clazz.getClassLoader()).asSubclass(AttributeImpl.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Cannot find implementing class for: " + clazz.getName());
            }
        }
    }
}

