/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;

public class BitSetIterator
extends DocIdSetIterator {
    private final BitSet bits;
    private final int length;
    private final long cost;
    private int doc = -1;

    private static <T extends BitSet> T getBitSet(DocIdSetIterator docIdSetIterator, Class<? extends T> clazz) {
        if (docIdSetIterator instanceof BitSetIterator) {
            BitSet bitSet = ((BitSetIterator)docIdSetIterator).bits;
            assert (bitSet != null);
            if (clazz.isInstance(bitSet)) {
                return (T)((BitSet)clazz.cast(bitSet));
            }
        }
        return null;
    }

    public static FixedBitSet getFixedBitSetOrNull(DocIdSetIterator docIdSetIterator) {
        return BitSetIterator.getBitSet(docIdSetIterator, FixedBitSet.class);
    }

    public BitSetIterator(BitSet bitSet, long l2) {
        this.bits = bitSet;
        this.length = bitSet.length();
        this.cost = l2;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() {
        return this.advance(this.doc + 1);
    }

    @Override
    public int advance(int n2) {
        if (n2 >= this.length) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.bits.nextSetBit(n2);
        return this.doc;
    }

    @Override
    public long cost() {
        return this.cost;
    }
}

