/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;

public final class BytesRef
implements Cloneable,
Comparable<BytesRef> {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public byte[] bytes;
    public int offset;
    public int length;
    private static final Comparator<BytesRef> utf8SortedAsUnicodeSortOrder = new b();
    @Deprecated
    private static final Comparator<BytesRef> utf8SortedAsUTF16SortOrder = new a();

    public BytesRef() {
        this(EMPTY_BYTES);
    }

    public BytesRef(byte[] byArray, int n2, int n3) {
        this.bytes = byArray;
        this.offset = n2;
        this.length = n3;
        assert (this.isValid());
    }

    public BytesRef(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public BytesRef(int n2) {
        this.bytes = new byte[n2];
    }

    public BytesRef(CharSequence charSequence) {
        this(new byte[3 * charSequence.length()]);
        this.length = UnicodeUtil.UTF16toUTF8(charSequence, 0, charSequence.length(), this.bytes);
    }

    public boolean bytesEquals(BytesRef bytesRef) {
        assert (bytesRef != null);
        if (this.length == bytesRef.length) {
            int n2 = bytesRef.offset;
            byte[] byArray = bytesRef.bytes;
            int n3 = this.offset + this.length;
            int n4 = this.offset;
            while (n4 < n3) {
                if (this.bytes[n4] != byArray[n2]) {
                    return false;
                }
                ++n4;
                ++n2;
            }
            return true;
        }
        return false;
    }

    public BytesRef clone() {
        return new BytesRef(this.bytes, this.offset, this.length);
    }

    public int hashCode() {
        return StringHelper.murmurhash3_x86_32(this, StringHelper.GOOD_FAST_HASH_SEED);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof BytesRef) {
            return this.bytesEquals((BytesRef)object);
        }
        return false;
    }

    public String utf8ToString() {
        char[] cArray = new char[this.length];
        int n2 = UnicodeUtil.UTF8toUTF16(this.bytes, this.offset, this.length, cArray);
        return new String(cArray, 0, n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = this.offset + this.length;
        for (int i2 = this.offset; i2 < n2; ++i2) {
            if (i2 > this.offset) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(Integer.toHexString(this.bytes[i2] & 0xFF));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(BytesRef bytesRef) {
        return utf8SortedAsUnicodeSortOrder.compare(this, bytesRef);
    }

    public static Comparator<BytesRef> getUTF8SortedAsUnicodeComparator() {
        return utf8SortedAsUnicodeSortOrder;
    }

    public static BytesRef deepCopyOf(BytesRef bytesRef) {
        BytesRef bytesRef2 = new BytesRef();
        bytesRef2.bytes = Arrays.copyOfRange(bytesRef.bytes, bytesRef.offset, bytesRef.offset + bytesRef.length);
        bytesRef2.offset = 0;
        bytesRef2.length = bytesRef.length;
        return bytesRef2;
    }

    public boolean isValid() {
        if (this.bytes == null) {
            throw new IllegalStateException("bytes is null");
        }
        if (this.length < 0) {
            throw new IllegalStateException("length is negative: " + this.length);
        }
        if (this.length > this.bytes.length) {
            throw new IllegalStateException("length is out of bounds: " + this.length + ",bytes.length=" + this.bytes.length);
        }
        if (this.offset < 0) {
            throw new IllegalStateException("offset is negative: " + this.offset);
        }
        if (this.offset > this.bytes.length) {
            throw new IllegalStateException("offset out of bounds: " + this.offset + ",bytes.length=" + this.bytes.length);
        }
        if (this.offset + this.length < 0) {
            throw new IllegalStateException("offset+length is negative: offset=" + this.offset + ",length=" + this.length);
        }
        if (this.offset + this.length > this.bytes.length) {
            throw new IllegalStateException("offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",bytes.length=" + this.bytes.length);
        }
        return true;
    }

    @Deprecated
    private static class a
    implements Comparator<BytesRef> {
        private a() {
        }

        public int a(BytesRef bytesRef, BytesRef bytesRef2) {
            byte[] byArray = bytesRef.bytes;
            int n2 = bytesRef.offset;
            byte[] byArray2 = bytesRef2.bytes;
            int n3 = bytesRef2.offset;
            int n4 = bytesRef.length < bytesRef2.length ? n2 + bytesRef.length : n2 + bytesRef2.length;
            while (n2 < n4) {
                int n5;
                int n6;
                if ((n6 = byArray[n2++] & 0xFF) == (n5 = byArray2[n3++] & 0xFF)) continue;
                if (n6 >= 238 && n5 >= 238) {
                    if ((n6 & 0xFE) == 238) {
                        n6 += 14;
                    }
                    if ((n5 & 0xFE) == 238) {
                        n5 += 14;
                    }
                }
                return n6 - n5;
            }
            return bytesRef.length - bytesRef2.length;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((BytesRef)object, (BytesRef)object2);
        }
    }

    private static class b
    implements Comparator<BytesRef> {
        private b() {
        }

        public int a(BytesRef bytesRef, BytesRef bytesRef2) {
            byte[] byArray = bytesRef.bytes;
            int n2 = bytesRef.offset;
            byte[] byArray2 = bytesRef2.bytes;
            int n3 = bytesRef2.offset;
            int n4 = n2 + Math.min(bytesRef.length, bytesRef2.length);
            while (n2 < n4) {
                int n5;
                int n6;
                int n7;
                if ((n7 = (n6 = byArray[n2++] & 0xFF) - (n5 = byArray2[n3++] & 0xFF)) == 0) continue;
                return n7;
            }
            return bytesRef.length - bytesRef2.length;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((BytesRef)object, (BytesRef)object2);
        }
    }
}

