/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;

public class BytesRefBuilder {
    private final BytesRef ref = new BytesRef();

    public byte[] bytes() {
        return this.ref.bytes;
    }

    public int length() {
        return this.ref.length;
    }

    public void setLength(int n2) {
        this.ref.length = n2;
    }

    public byte byteAt(int n2) {
        return this.ref.bytes[n2];
    }

    public void setByteAt(int n2, byte by) {
        this.ref.bytes[n2] = by;
    }

    public void grow(int n2) {
        this.ref.bytes = ArrayUtil.grow(this.ref.bytes, n2);
    }

    public void append(byte by) {
        this.grow(this.ref.length + 1);
        this.ref.bytes[this.ref.length++] = by;
    }

    public void append(byte[] byArray, int n2, int n3) {
        this.grow(this.ref.length + n3);
        System.arraycopy(byArray, n2, this.ref.bytes, this.ref.length, n3);
        this.ref.length += n3;
    }

    public void append(BytesRef bytesRef) {
        this.append(bytesRef.bytes, bytesRef.offset, bytesRef.length);
    }

    public void append(BytesRefBuilder bytesRefBuilder) {
        this.append(bytesRefBuilder.get());
    }

    public void clear() {
        this.setLength(0);
    }

    public void copyBytes(BytesRef bytesRef) {
        this.clear();
        this.append(bytesRef);
    }

    public void copyChars(char[] cArray, int n2, int n3) {
        this.grow(n3 * 3);
        this.ref.length = UnicodeUtil.UTF16toUTF8(cArray, n2, n3, this.ref.bytes);
    }

    public BytesRef get() {
        assert (this.ref.offset == 0) : "Modifying the offset of the returned ref is illegal";
        return this.ref;
    }

    public boolean equals(Object object) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

