/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class CloseableThreadLocal<T>
implements Closeable {
    private ThreadLocal<WeakReference<T>> t = new ThreadLocal();
    private Map<Thread, T> hardRefs = new WeakHashMap<Thread, T>();
    private static int PURGE_MULTIPLIER = 20;
    private final AtomicInteger countUntilPurge = new AtomicInteger(PURGE_MULTIPLIER);

    protected T initialValue() {
        return null;
    }

    public T get() {
        WeakReference<T> weakReference = this.t.get();
        if (weakReference == null) {
            T t2 = this.initialValue();
            if (t2 != null) {
                this.set(t2);
                return t2;
            }
            return null;
        }
        this.maybePurge();
        return weakReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T t2) {
        this.t.set(new WeakReference<T>(t2));
        Map<Thread, T> map = this.hardRefs;
        synchronized (map) {
            this.hardRefs.put(Thread.currentThread(), t2);
            this.maybePurge();
        }
    }

    private void maybePurge() {
        if (this.countUntilPurge.getAndDecrement() == 0) {
            this.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        Map<Thread, T> map = this.hardRefs;
        synchronized (map) {
            int n2 = 0;
            Iterator<Thread> iterator = this.hardRefs.keySet().iterator();
            while (iterator.hasNext()) {
                Thread thread = iterator.next();
                if (!thread.isAlive()) {
                    iterator.remove();
                    continue;
                }
                ++n2;
            }
            int n3 = (1 + n2) * PURGE_MULTIPLIER;
            if (n3 <= 0) {
                n3 = 1000000;
            }
            this.countUntilPurge.set(n3);
        }
    }

    @Override
    public void close() {
        this.hardRefs = null;
        if (this.t != null) {
            this.t.remove();
        }
        this.t = null;
    }
}

