/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;

public final class GrowableByteArrayDataOutput
extends DataOutput {
    public byte[] bytes;
    public int length;

    public GrowableByteArrayDataOutput(int n2) {
        this.bytes = new byte[ArrayUtil.oversize(n2, 1)];
        this.length = 0;
    }

    @Override
    public void writeByte(byte by) {
        if (this.length >= this.bytes.length) {
            this.bytes = ArrayUtil.grow(this.bytes);
        }
        this.bytes[this.length++] = by;
    }

    @Override
    public void writeBytes(byte[] byArray, int n2, int n3) {
        int n4 = this.length + n3;
        this.bytes = ArrayUtil.grow(this.bytes, n4);
        System.arraycopy(byArray, n2, this.bytes, this.length, n3);
        this.length = n4;
    }
}

