/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.lucene.portmobile.charset.StandardCharsets;
import org.apache.lucene.portmobile.file.Path;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FileSwitchDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.c;
import org.apache.lucene.util.Constants;

public final class IOUtils {
    @Deprecated
    public static final Charset CHARSET_UTF_8 = StandardCharsets.UTF_8;
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    private IOUtils() {
    }

    public static void close(Closeable ... closeableArray) throws IOException {
        IOUtils.close(Arrays.asList(closeableArray));
    }

    public static void close(Iterable<? extends Closeable> iterable) throws IOException {
        Throwable throwable = null;
        for (Closeable closeable : iterable) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable2) {
                IOUtils.addSuppressed(throwable, throwable2);
                if (throwable != null) continue;
                throwable = throwable2;
            }
        }
        IOUtils.reThrow(throwable);
    }

    public static void closeWhileHandlingException(Closeable ... closeableArray) {
        IOUtils.closeWhileHandlingException(Arrays.asList(closeableArray));
    }

    public static void closeWhileHandlingException(Iterable<? extends Closeable> iterable) {
        for (Closeable closeable : iterable) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static void addSuppressed(Throwable throwable, Throwable throwable2) {
        if (throwable != null && throwable2 != null) {
            throwable.addSuppressed(throwable2);
        }
    }

    public static void deleteFilesIgnoringExceptions(c c2, String ... stringArray) {
        for (String string : stringArray) {
            try {
                c2.deleteFile(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void reThrow(Throwable throwable) throws IOException {
        if (throwable != null) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            IOUtils.reThrowUnchecked(throwable);
        }
    }

    public static void reThrowUnchecked(Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    /*
     * Exception decompiling
     */
    public static void fsync(Path var0, boolean var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean spins(c c2) throws IOException {
        if ((c2 = FilterDirectory.unwrap(c2)) instanceof FileSwitchDirectory) {
            FileSwitchDirectory fileSwitchDirectory = (FileSwitchDirectory)c2;
            return IOUtils.spins(fileSwitchDirectory.getPrimaryDir()) || IOUtils.spins(fileSwitchDirectory.getSecondaryDir());
        }
        if (c2 instanceof RAMDirectory) {
            return false;
        }
        if (c2 instanceof FSDirectory) {
            return IOUtils.spins(((FSDirectory)c2).getDirectory());
        }
        return true;
    }

    public static boolean spins(Path path) throws IOException {
        path = path.toRealPath();
        if (!Constants.LINUX) {
            return true;
        }
        try {
            return IOUtils.spinsLinux(path);
        }
        catch (Exception exception) {
            return true;
        }
    }

    static boolean spinsLinux(Path path) throws IOException {
        return false;
    }
}

