/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;

public final class IntBlockPool {
    public int[][] buffers = new int[10][];
    private int bufferUpto = -1;
    public int intUpto = 8192;
    public int[] buffer;
    public int intOffset = -8192;
    private final Allocator allocator;
    private static final int[] NEXT_LEVEL_ARRAY = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 9};
    private static final int[] LEVEL_SIZE_ARRAY = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static final int FIRST_LEVEL_SIZE = LEVEL_SIZE_ARRAY[0];

    public IntBlockPool() {
        this(new a());
    }

    public IntBlockPool(Allocator allocator) {
        this.allocator = allocator;
    }

    public void reset(boolean bl, boolean bl2) {
        if (this.bufferUpto != -1) {
            int n2;
            if (bl) {
                for (n2 = 0; n2 < this.bufferUpto; ++n2) {
                    Arrays.fill(this.buffers[n2], 0);
                }
                Arrays.fill(this.buffers[this.bufferUpto], 0, this.intUpto, 0);
            }
            if (this.bufferUpto > 0 || !bl2) {
                n2 = bl2 ? 1 : 0;
                this.allocator.recycleIntBlocks(this.buffers, n2, 1 + this.bufferUpto);
                Arrays.fill((Object[])this.buffers, n2, this.bufferUpto + 1, null);
            }
            if (bl2) {
                this.bufferUpto = 0;
                this.intUpto = 0;
                this.intOffset = 0;
                this.buffer = this.buffers[0];
            } else {
                this.bufferUpto = -1;
                this.intUpto = 8192;
                this.intOffset = -8192;
                this.buffer = null;
            }
        }
    }

    public void nextBuffer() {
        if (1 + this.bufferUpto == this.buffers.length) {
            int[][] nArrayArray = new int[(int)((double)this.buffers.length * 1.5)][];
            System.arraycopy(this.buffers, 0, nArrayArray, 0, this.buffers.length);
            this.buffers = nArrayArray;
        }
        int[] nArray = this.allocator.getIntBlock();
        this.buffers[1 + this.bufferUpto] = nArray;
        this.buffer = nArray;
        ++this.bufferUpto;
        this.intUpto = 0;
        this.intOffset += 8192;
    }

    public static final class a
    extends Allocator {
        public a() {
            super(8192);
        }

        @Override
        public void recycleIntBlocks(int[][] nArray, int n2, int n3) {
        }
    }

    public static abstract class Allocator {
        protected final int blockSize;

        public Allocator(int n2) {
            this.blockSize = n2;
        }

        public abstract void recycleIntBlocks(int[][] var1, int var2, int var3);

        public int[] getIntBlock() {
            return new int[this.blockSize];
        }
    }
}

