/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class RefCount<T> {
    private final AtomicInteger refCount = new AtomicInteger(1);
    protected final T object;

    public RefCount(T t2) {
        this.object = t2;
    }

    protected void release() throws IOException {
    }

    public final void decRef() throws IOException {
        int n2 = this.refCount.decrementAndGet();
        if (n2 == 0) {
            boolean bl = false;
            try {
                this.release();
                bl = true;
            }
            finally {
                if (!bl) {
                    this.refCount.incrementAndGet();
                }
            }
        } else if (n2 < 0) {
            throw new IllegalStateException("too many decRef calls: refCount is " + n2 + " after decrement");
        }
    }

    public final T get() {
        return this.object;
    }

    public final void incRef() {
        this.refCount.incrementAndGet();
    }
}

