/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.BytesRef;

public final class UnicodeUtil {
    public static final BytesRef BIG_TERM = new BytesRef(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
    static final int[] utf8CodeLength;

    private UnicodeUtil() {
    }

    public static int UTF16toUTF8(char[] cArray, int n2, int n3, byte[] byArray) {
        int n4 = 0;
        int n5 = n2;
        int n6 = n2 + n3;
        while (n5 < n6) {
            int n7;
            char c2;
            if ((c2 = cArray[n5++]) < '\u0080') {
                byArray[n4++] = (byte)c2;
                continue;
            }
            if (c2 < '\u0800') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 < '\ud800' || c2 > '\udfff') {
                byArray[n4++] = (byte)(0xE0 | c2 >> 12);
                byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 < '\udc00' && n5 < n6 && (n7 = cArray[n5]) >= 56320 && n7 <= 57343) {
                n7 = (c2 << 10) + n7 + -56613888;
                ++n5;
                byArray[n4++] = (byte)(0xF0 | n7 >> 18);
                byArray[n4++] = (byte)(0x80 | n7 >> 12 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n7 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n7 & 0x3F);
                continue;
            }
            byArray[n4++] = -17;
            byArray[n4++] = -65;
            byArray[n4++] = -67;
        }
        return n4;
    }

    public static int UTF16toUTF8(CharSequence charSequence, int n2, int n3, byte[] byArray) {
        int n4 = n2 + n3;
        int n5 = 0;
        for (int i2 = n2; i2 < n4; ++i2) {
            int n6;
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0080') {
                byArray[n5++] = (byte)c2;
                continue;
            }
            if (c2 < '\u0800') {
                byArray[n5++] = (byte)(0xC0 | c2 >> 6);
                byArray[n5++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 < '\ud800' || c2 > '\udfff') {
                byArray[n5++] = (byte)(0xE0 | c2 >> 12);
                byArray[n5++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n5++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 < '\udc00' && i2 < n4 - 1 && (n6 = charSequence.charAt(i2 + 1)) >= 56320 && n6 <= 57343) {
                n6 = (c2 << 10) + n6 + -56613888;
                ++i2;
                byArray[n5++] = (byte)(0xF0 | n6 >> 18);
                byArray[n5++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                byArray[n5++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                byArray[n5++] = (byte)(0x80 | n6 & 0x3F);
                continue;
            }
            byArray[n5++] = -17;
            byArray[n5++] = -65;
            byArray[n5++] = -67;
        }
        return n5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int codePointCount(BytesRef bytesRef) {
        int n2 = bytesRef.offset;
        int n3 = n2 + bytesRef.length;
        byte[] byArray = bytesRef.bytes;
        int n4 = 0;
        while (n2 < n3) {
            int n5 = byArray[n2] & 0xFF;
            if (n5 < 128) {
                ++n2;
            } else {
                if (n5 < 192) throw new IllegalArgumentException();
                if (n5 < 224) {
                    n2 += 2;
                } else if (n5 < 240) {
                    n2 += 3;
                } else {
                    if (n5 >= 248) throw new IllegalArgumentException();
                    n2 += 4;
                }
            }
            ++n4;
        }
        if (n2 <= n3) return n4;
        throw new IllegalArgumentException();
    }

    public static String newString(int[] nArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = n2 + n3;
        block2: for (int i2 = n2; i2 < n5; ++i2) {
            int n6 = nArray[i2];
            if (n6 < 0 || n6 > 0x10FFFF) {
                throw new IllegalArgumentException();
            }
            while (true) {
                try {
                    if (n6 < 65536) {
                        cArray[n4] = (char)n6;
                        ++n4;
                        continue block2;
                    }
                    cArray[n4] = (char)(55232 + (n6 >> 10));
                    cArray[n4 + 1] = (char)(56320 + (n6 & 0x3FF));
                    n4 += 2;
                    continue block2;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    int n7 = (int)Math.ceil((double)nArray.length * (double)(n4 + 2) / (double)(i2 - n2 + 1));
                    char[] cArray2 = new char[n7];
                    System.arraycopy(cArray, 0, cArray2, 0, n4);
                    cArray = cArray2;
                    continue;
                }
                break;
            }
        }
        return new String(cArray, 0, n4);
    }

    public static int UTF8toUTF16(byte[] byArray, int n2, int n3, char[] cArray) {
        int n4 = 0;
        int n5 = n2 + n3;
        while (n2 < n5) {
            int n6;
            if ((n6 = byArray[n2++] & 0xFF) < 192) {
                assert (n6 < 128);
                cArray[n4++] = (char)n6;
                continue;
            }
            if (n6 < 224) {
                cArray[n4++] = (char)(((n6 & 0x1F) << 6) + (byArray[n2++] & 0x3F));
                continue;
            }
            if (n6 < 240) {
                cArray[n4++] = (char)(((n6 & 0xF) << 12) + ((byArray[n2] & 0x3F) << 6) + (byArray[n2 + 1] & 0x3F));
                n2 += 2;
                continue;
            }
            assert (n6 < 248) : "b = 0x" + Integer.toHexString(n6);
            int n7 = ((n6 & 7) << 18) + ((byArray[n2] & 0x3F) << 12) + ((byArray[n2 + 1] & 0x3F) << 6) + (byArray[n2 + 2] & 0x3F);
            n2 += 3;
            if ((long)n7 < 65535L) {
                cArray[n4++] = (char)n7;
                continue;
            }
            int n8 = n7 - 65536;
            cArray[n4++] = (char)((n8 >> 10) + 55296);
            cArray[n4++] = (char)(((long)n8 & 0x3FFL) + 56320L);
        }
        return n4;
    }

    static {
        int n2 = Integer.MIN_VALUE;
        utf8CodeLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4};
    }
}

