/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.Iterator;
import java.util.TreeSet;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Lev1ParametricDescription;
import org.apache.lucene.util.automaton.Lev1TParametricDescription;
import org.apache.lucene.util.automaton.Lev2ParametricDescription;
import org.apache.lucene.util.automaton.Lev2TParametricDescription;

public class LevenshteinAutomata {
    final int[] word;
    final int[] alphabet;
    final int alphaMax;
    final int[] rangeLower;
    final int[] rangeUpper;
    int numRanges = 0;
    ParametricDescription[] descriptions;

    public LevenshteinAutomata(String string, boolean bl) {
        this(LevenshteinAutomata.codePoints(string), 0x10FFFF, bl);
    }

    public LevenshteinAutomata(int[] nArray, int n2, boolean bl) {
        int n3;
        this.word = nArray;
        this.alphaMax = n2;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n3 = nArray[i2];
            if (n3 > n2) {
                throw new IllegalArgumentException("alphaMax exceeded by symbol " + n3 + " in word");
            }
            treeSet.add(n3);
        }
        this.alphabet = new int[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        for (n3 = 0; n3 < this.alphabet.length; ++n3) {
            this.alphabet[n3] = (Integer)iterator.next();
        }
        this.rangeLower = new int[this.alphabet.length + 2];
        this.rangeUpper = new int[this.alphabet.length + 2];
        n3 = 0;
        for (int i3 = 0; i3 < this.alphabet.length; ++i3) {
            int n4 = this.alphabet[i3];
            if (n4 > n3) {
                this.rangeLower[this.numRanges] = n3;
                this.rangeUpper[this.numRanges] = n4 - 1;
                ++this.numRanges;
            }
            n3 = n4 + 1;
        }
        if (n3 <= n2) {
            this.rangeLower[this.numRanges] = n3;
            this.rangeUpper[this.numRanges] = n2;
            ++this.numRanges;
        }
        this.descriptions = new ParametricDescription[]{null, bl ? new Lev1TParametricDescription(nArray.length) : new Lev1ParametricDescription(nArray.length), bl ? new Lev2TParametricDescription(nArray.length) : new Lev2ParametricDescription(nArray.length)};
    }

    private static int[] codePoints(String string) {
        int n2 = Character.codePointCount(string, 0, string.length());
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < string.length(); i2 += Character.charCount(n4)) {
            nArray[n3++] = n4 = string.codePointAt(i2);
        }
        return nArray;
    }

    public Automaton toAutomaton(int n2, String string) {
        int n3;
        int n4;
        int n5;
        int n6;
        assert (string != null);
        if (n2 == 0) {
            return Automata.makeString(string + UnicodeUtil.newString(this.word, 0, this.word.length));
        }
        if (n2 >= this.descriptions.length) {
            return null;
        }
        int n7 = 2 * n2 + 1;
        ParametricDescription parametricDescription = this.descriptions[n2];
        int n8 = parametricDescription.size();
        Automaton automaton = new Automaton();
        if (string != null) {
            n6 = automaton.createState();
            n5 = 0;
            for (n4 = 0; n4 < string.length(); n4 += Character.charCount(n5)) {
                n3 = automaton.createState();
                n5 = string.codePointAt(n4);
                automaton.addTransition(n6, n3, n5, n5);
                n6 = n3;
            }
        } else {
            n6 = automaton.createState();
        }
        n4 = n6;
        automaton.setAccept(n6, parametricDescription.isAccept(0));
        for (n5 = 1; n5 < n8; ++n5) {
            n3 = automaton.createState();
            automaton.setAccept(n3, parametricDescription.isAccept(n5));
        }
        for (n5 = 0; n5 < n8; ++n5) {
            int n9;
            int n10;
            n3 = parametricDescription.getPosition(n5);
            if (n3 < 0) continue;
            int n11 = n3 + Math.min(this.word.length - n3, n7);
            for (n10 = 0; n10 < this.alphabet.length; ++n10) {
                n9 = this.alphabet[n10];
                int n12 = this.getVector(n9, n3, n11);
                int n13 = parametricDescription.transition(n5, n3, n12);
                if (n13 < 0) continue;
                automaton.addTransition(n4 + n5, n4 + n13, n9);
            }
            n10 = parametricDescription.transition(n5, n3, 0);
            if (n10 < 0) continue;
            for (n9 = 0; n9 < this.numRanges; ++n9) {
                automaton.addTransition(n4 + n5, n4 + n10, this.rangeLower[n9], this.rangeUpper[n9]);
            }
        }
        automaton.finishState();
        assert (automaton.isDeterministic());
        return automaton;
    }

    int getVector(int n2, int n3, int n4) {
        int n5 = 0;
        for (int i2 = n3; i2 < n4; ++i2) {
            n5 <<= 1;
            if (this.word[i2] != n2) continue;
            n5 |= 1;
        }
        return n5;
    }

    static abstract class ParametricDescription {
        protected final int w;
        protected final int n;
        private final int[] minErrors;
        private static final long[] MASKS = new long[]{1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE};

        ParametricDescription(int n2, int n3, int[] nArray) {
            this.w = n2;
            this.n = n3;
            this.minErrors = nArray;
        }

        int size() {
            return this.minErrors.length * (this.w + 1);
        }

        boolean isAccept(int n2) {
            int n3 = n2 / (this.w + 1);
            int n4 = n2 % (this.w + 1);
            assert (n4 >= 0);
            return this.w - n4 + this.minErrors[n3] <= this.n;
        }

        int getPosition(int n2) {
            return n2 % (this.w + 1);
        }

        abstract int transition(int var1, int var2, int var3);

        protected int unpack(long[] lArray, int n2, int n3) {
            long l2 = n3 * n2;
            int n4 = (int)(l2 >> 6);
            int n5 = (int)(l2 & 0x3FL);
            if (n5 + n3 <= 64) {
                return (int)(lArray[n4] >> n5 & MASKS[n3 - 1]);
            }
            int n6 = 64 - n5;
            return (int)((lArray[n4] >> n5 & MASKS[n6 - 1]) + ((lArray[1 + n4] & MASKS[n3 - n6 - 1]) << n6));
        }
    }
}

