/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.SortedIntSet;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.apache.lucene.util.automaton.Transition;

public final class Operations {
    private Operations() {
    }

    public static boolean hasDeadStates(Automaton automaton) {
        BitSet bitSet = Operations.getLiveStates(automaton);
        int n2 = bitSet.cardinality();
        int n3 = automaton.getNumStates();
        assert (n2 <= n3) : "numLive=" + n2 + " numStates=" + n3 + " " + bitSet;
        return n2 < n3;
    }

    public static Automaton determinize(Automaton automaton, int n2) {
        Object object;
        if (automaton.isDeterministic()) {
            return automaton;
        }
        if (automaton.getNumStates() <= 1) {
            return automaton;
        }
        Automaton.Builder builder = new Automaton.Builder();
        SortedIntSet.FrozenIntSet frozenIntSet = new SortedIntSet.FrozenIntSet(0, 0);
        builder.createState();
        LinkedList<SortedIntSet.FrozenIntSet> linkedList = new LinkedList<SortedIntSet.FrozenIntSet>();
        HashMap<SortedIntSet.FrozenIntSet, Object> hashMap = new HashMap<SortedIntSet.FrozenIntSet, Object>();
        linkedList.add(frozenIntSet);
        builder.setAccept(0, automaton.isAccept(0));
        hashMap.put(frozenIntSet, 0);
        PointTransitionSet pointTransitionSet = new PointTransitionSet();
        SortedIntSet sortedIntSet = new SortedIntSet(5);
        Transition transition = new Transition();
        while (linkedList.size() > 0) {
            int n3;
            int n4;
            int n5;
            int n6;
            object = (SortedIntSet.FrozenIntSet)linkedList.removeFirst();
            for (n6 = 0; n6 < ((SortedIntSet.FrozenIntSet)object).values.length; ++n6) {
                n5 = ((SortedIntSet.FrozenIntSet)object).values[n6];
                n4 = automaton.getNumTransitions(n5);
                automaton.initTransition(n5, transition);
                for (n3 = 0; n3 < n4; ++n3) {
                    automaton.getNextTransition(transition);
                    pointTransitionSet.add(transition);
                }
            }
            if (pointTransitionSet.count == 0) continue;
            pointTransitionSet.sort();
            n6 = -1;
            n5 = 0;
            n4 = ((SortedIntSet.FrozenIntSet)object).state;
            for (n3 = 0; n3 < pointTransitionSet.count; ++n3) {
                Object object2;
                int n7;
                Object object3;
                int n8 = pointTransitionSet.points[n3].point;
                if (sortedIntSet.upto > 0) {
                    assert (n6 != -1);
                    sortedIntSet.computeHash();
                    object3 = (Integer)hashMap.get(sortedIntSet);
                    if (object3 == null) {
                        object3 = builder.createState();
                        if ((Integer)object3 >= n2) {
                            throw new TooComplexToDeterminizeException(automaton, n2);
                        }
                        SortedIntSet.FrozenIntSet frozenIntSet2 = sortedIntSet.freeze((Integer)object3);
                        linkedList.add(frozenIntSet2);
                        builder.setAccept((Integer)object3, n5 > 0);
                        hashMap.put(frozenIntSet2, object3);
                    } else assert (n5 > 0 == builder.isAccept((Integer)object3)) : "accCount=" + n5 + " vs existing accept=" + builder.isAccept((Integer)object3) + " states=" + sortedIntSet;
                    builder.addTransition(n4, (Integer)object3, n6, n8 - 1);
                }
                object3 = pointTransitionSet.points[n3].ends.transitions;
                int n9 = pointTransitionSet.points[n3].ends.next;
                for (n7 = 0; n7 < n9; n7 += 3) {
                    object2 = object3[n7];
                    sortedIntSet.decr((int)object2);
                    n5 -= automaton.isAccept((int)object2) ? 1 : 0;
                }
                pointTransitionSet.points[n3].ends.next = 0;
                object3 = pointTransitionSet.points[n3].starts.transitions;
                n9 = pointTransitionSet.points[n3].starts.next;
                for (n7 = 0; n7 < n9; n7 += 3) {
                    object2 = object3[n7];
                    sortedIntSet.incr((int)object2);
                    n5 += automaton.isAccept((int)object2) ? 1 : 0;
                }
                n6 = n8;
                pointTransitionSet.points[n3].starts.next = 0;
            }
            pointTransitionSet.reset();
            assert (sortedIntSet.upto == 0) : "upto=" + sortedIntSet.upto;
        }
        object = builder.finish();
        assert (((Automaton)object).isDeterministic());
        return object;
    }

    public static boolean isEmpty(Automaton automaton) {
        if (automaton.getNumStates() == 0) {
            return true;
        }
        if (!automaton.isAccept(0) && automaton.getNumTransitions(0) == 0) {
            return true;
        }
        if (automaton.isAccept(0)) {
            return false;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        BitSet bitSet = new BitSet(automaton.getNumStates());
        linkedList.add(0);
        bitSet.set(0);
        Transition transition = new Transition();
        while (!linkedList.isEmpty()) {
            int n2 = (Integer)linkedList.removeFirst();
            if (automaton.isAccept(n2)) {
                return false;
            }
            int n3 = automaton.initTransition(n2, transition);
            for (int i2 = 0; i2 < n3; ++i2) {
                automaton.getNextTransition(transition);
                if (bitSet.get(transition.dest)) continue;
                linkedList.add(transition.dest);
                bitSet.set(transition.dest);
            }
        }
        return true;
    }

    public static boolean isTotal(Automaton automaton) {
        return Operations.isTotal(automaton, 0, 0x10FFFF);
    }

    public static boolean isTotal(Automaton automaton, int n2, int n3) {
        if (automaton.isAccept(0) && automaton.getNumTransitions(0) == 1) {
            Transition transition = new Transition();
            automaton.getTransition(0, 0, transition);
            return transition.dest == 0 && transition.min == n2 && transition.max == n3;
        }
        return false;
    }

    private static BitSet getLiveStates(Automaton automaton) {
        BitSet bitSet = Operations.getLiveStatesFromInitial(automaton);
        bitSet.and(Operations.getLiveStatesToAccept(automaton));
        return bitSet;
    }

    private static BitSet getLiveStatesFromInitial(Automaton automaton) {
        int n2 = automaton.getNumStates();
        BitSet bitSet = new BitSet(n2);
        if (n2 == 0) {
            return bitSet;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        bitSet.set(0);
        linkedList.add(0);
        Transition transition = new Transition();
        while (!linkedList.isEmpty()) {
            int n3 = (Integer)linkedList.removeFirst();
            int n4 = automaton.initTransition(n3, transition);
            for (int i2 = 0; i2 < n4; ++i2) {
                automaton.getNextTransition(transition);
                if (bitSet.get(transition.dest)) continue;
                bitSet.set(transition.dest);
                linkedList.add(transition.dest);
            }
        }
        return bitSet;
    }

    private static BitSet getLiveStatesToAccept(Automaton automaton) {
        int n2;
        int n3;
        Automaton.Builder builder = new Automaton.Builder();
        Transition transition = new Transition();
        int n4 = automaton.getNumStates();
        for (n3 = 0; n3 < n4; ++n3) {
            builder.createState();
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = automaton.initTransition(n3, transition);
            for (int i2 = 0; i2 < n5; ++i2) {
                automaton.getNextTransition(transition);
                builder.addTransition(transition.dest, n3, transition.min, transition.max);
            }
        }
        Automaton automaton2 = builder.finish();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        BitSet bitSet = new BitSet(n4);
        BitSet bitSet2 = automaton.getAcceptStates();
        for (n2 = 0; n2 < n4 && (n2 = bitSet2.nextSetBit(n2)) != -1; ++n2) {
            bitSet.set(n2);
            linkedList.add(n2);
        }
        while (!linkedList.isEmpty()) {
            n2 = (Integer)linkedList.removeFirst();
            int n6 = automaton2.initTransition(n2, transition);
            for (int i3 = 0; i3 < n6; ++i3) {
                automaton2.getNextTransition(transition);
                if (bitSet.get(transition.dest)) continue;
                bitSet.set(transition.dest);
                linkedList.add(transition.dest);
            }
        }
        return bitSet;
    }

    static int findIndex(int n2, int[] nArray) {
        int n3 = 0;
        int n4 = nArray.length;
        while (n4 - n3 > 1) {
            int n5 = n3 + n4 >>> 1;
            if (nArray[n5] > n2) {
                n4 = n5;
                continue;
            }
            if (nArray[n5] < n2) {
                n3 = n5;
                continue;
            }
            return n5;
        }
        return n3;
    }

    public static boolean isFinite(Automaton automaton) {
        if (automaton.getNumStates() == 0) {
            return true;
        }
        return Operations.isFinite(new Transition(), automaton, 0, new BitSet(automaton.getNumStates()), new BitSet(automaton.getNumStates()));
    }

    private static boolean isFinite(Transition transition, Automaton automaton, int n2, BitSet bitSet, BitSet bitSet2) {
        bitSet.set(n2);
        int n3 = automaton.initTransition(n2, transition);
        for (int i2 = 0; i2 < n3; ++i2) {
            automaton.getTransition(n2, i2, transition);
            if (!bitSet.get(transition.dest) && (bitSet2.get(transition.dest) || Operations.isFinite(transition, automaton, transition.dest, bitSet, bitSet2))) continue;
            return false;
        }
        bitSet.clear(n2);
        bitSet2.set(n2);
        return true;
    }

    public static BytesRef getCommonPrefixBytesRef(Automaton automaton) {
        boolean bl;
        BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = 0;
        Transition transition = new Transition();
        do {
            bl = true;
            hashSet.add(n2);
            if (automaton.isAccept(n2) || automaton.getNumTransitions(n2) != 1) continue;
            automaton.getTransition(n2, 0, transition);
            if (transition.min != transition.max || hashSet.contains(transition.dest)) continue;
            bytesRefBuilder.append((byte)transition.min);
            n2 = transition.dest;
            bl = false;
        } while (!bl);
        return bytesRefBuilder.get();
    }

    public static IntsRef getSingleton(Automaton automaton) {
        block5: {
            if (!automaton.isDeterministic()) {
                throw new IllegalArgumentException("input automaton must be deterministic");
            }
            IntsRefBuilder intsRefBuilder = new IntsRefBuilder();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            int n2 = 0;
            Transition transition = new Transition();
            while (true) {
                hashSet.add(n2);
                if (automaton.isAccept(n2)) break;
                if (automaton.getNumTransitions(n2) == 1) {
                    automaton.getTransition(n2, 0, transition);
                    if (transition.min == transition.max && !hashSet.contains(transition.dest)) {
                        intsRefBuilder.append(transition.min);
                        n2 = transition.dest;
                        continue;
                    }
                }
                break block5;
                break;
            }
            if (automaton.getNumTransitions(n2) == 0) {
                return intsRefBuilder.get();
            }
        }
        return null;
    }

    public static BytesRef getCommonSuffixBytesRef(Automaton automaton, int n2) {
        Automaton automaton2 = Operations.determinize(Operations.reverse(automaton), n2);
        BytesRef bytesRef = Operations.getCommonPrefixBytesRef(automaton2);
        Operations.reverseBytes(bytesRef);
        return bytesRef;
    }

    private static void reverseBytes(BytesRef bytesRef) {
        if (bytesRef.length <= 1) {
            return;
        }
        int n2 = bytesRef.length >> 1;
        for (int i2 = bytesRef.offset; i2 < bytesRef.offset + n2; ++i2) {
            byte by = bytesRef.bytes[i2];
            bytesRef.bytes[i2] = bytesRef.bytes[bytesRef.offset * 2 + bytesRef.length - i2 - 1];
            bytesRef.bytes[bytesRef.offset * 2 + bytesRef.length - i2 - 1] = by;
        }
    }

    public static Automaton reverse(Automaton automaton) {
        return Operations.reverse(automaton, null);
    }

    static Automaton reverse(Automaton automaton, Set<Integer> set) {
        int n2;
        if (Operations.isEmpty(automaton)) {
            return new Automaton();
        }
        int n3 = automaton.getNumStates();
        Automaton.Builder builder = new Automaton.Builder();
        builder.createState();
        for (int i2 = 0; i2 < n3; ++i2) {
            builder.createState();
        }
        builder.setAccept(1, true);
        Transition transition = new Transition();
        for (int i3 = 0; i3 < n3; ++i3) {
            n2 = automaton.getNumTransitions(i3);
            automaton.initTransition(i3, transition);
            for (int i4 = 0; i4 < n2; ++i4) {
                automaton.getNextTransition(transition);
                builder.addTransition(transition.dest + 1, i3 + 1, transition.min, transition.max);
            }
        }
        Automaton automaton2 = builder.finish();
        BitSet bitSet = automaton.getAcceptStates();
        for (n2 = 0; n2 < n3 && (n2 = bitSet.nextSetBit(n2)) != -1; ++n2) {
            automaton2.addEpsilon(0, n2 + 1);
            if (set == null) continue;
            set.add(n2 + 1);
        }
        automaton2.finishState();
        return automaton2;
    }

    private static final class PointTransitionSet {
        int count;
        PointTransitions[] points = new PointTransitions[5];
        private final HashMap<Integer, PointTransitions> map = new HashMap();
        private boolean useHash = false;

        private PointTransitionSet() {
        }

        private PointTransitions next(int n2) {
            Object object;
            if (this.count == this.points.length) {
                object = new PointTransitions[ArrayUtil.oversize(1 + this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.points, 0, object, 0, this.count);
                this.points = object;
            }
            if ((object = this.points[this.count]) == null) {
                this.points[this.count] = new PointTransitions();
                object = this.points[this.count];
            }
            object.reset(n2);
            ++this.count;
            return object;
        }

        private PointTransitions find(int n2) {
            if (this.useHash) {
                Integer n3 = n2;
                PointTransitions pointTransitions = this.map.get(n3);
                if (pointTransitions == null) {
                    pointTransitions = this.next(n2);
                    this.map.put(n3, pointTransitions);
                }
                return pointTransitions;
            }
            for (int i2 = 0; i2 < this.count; ++i2) {
                if (this.points[i2].point != n2) continue;
                return this.points[i2];
            }
            PointTransitions pointTransitions = this.next(n2);
            if (this.count == 30) {
                assert (this.map.size() == 0);
                for (int i3 = 0; i3 < this.count; ++i3) {
                    this.map.put(this.points[i3].point, this.points[i3]);
                }
                this.useHash = true;
            }
            return pointTransitions;
        }

        public void reset() {
            if (this.useHash) {
                this.map.clear();
                this.useHash = false;
            }
            this.count = 0;
        }

        public void sort() {
            if (this.count > 1) {
                ArrayUtil.timSort((Comparable[])this.points, (int)0, (int)this.count);
            }
        }

        public void add(Transition transition) {
            this.find((int)transition.min).starts.add(transition);
            this.find((int)(1 + transition.max)).ends.add(transition);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.count; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.points[i2].point).append(':').append(this.points[i2].starts.next / 3).append(',').append(this.points[i2].ends.next / 3);
            }
            return stringBuilder.toString();
        }
    }

    private static final class PointTransitions
    implements Comparable<PointTransitions> {
        int point;
        final TransitionList ends = new TransitionList();
        final TransitionList starts = new TransitionList();

        private PointTransitions() {
        }

        @Override
        public int compareTo(PointTransitions pointTransitions) {
            return this.point - pointTransitions.point;
        }

        public void reset(int n2) {
            this.point = n2;
            this.ends.next = 0;
            this.starts.next = 0;
        }

        public boolean equals(Object object) {
            return ((PointTransitions)object).point == this.point;
        }

        public int hashCode() {
            return this.point;
        }
    }

    private static final class TransitionList {
        int[] transitions = new int[3];
        int next;

        private TransitionList() {
        }

        public void add(Transition transition) {
            if (this.transitions.length < this.next + 3) {
                this.transitions = ArrayUtil.grow(this.transitions, this.next + 3);
            }
            this.transitions[this.next] = transition.dest;
            this.transitions[this.next + 1] = transition.min;
            this.transitions[this.next + 2] = transition.max;
            this.next += 3;
        }
    }
}

