/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.Arrays;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;

public abstract class RunAutomaton {
    final Automaton automaton;
    final int maxInterval;
    final int size;
    final boolean[] accept;
    final int initial;
    final int[] transitions;
    final int[] points;
    final int[] classmap;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("initial state: ").append(this.initial).append("\n");
        for (int i2 = 0; i2 < this.size; ++i2) {
            stringBuilder.append("state " + i2);
            if (this.accept[i2]) {
                stringBuilder.append(" [accept]:\n");
            } else {
                stringBuilder.append(" [reject]:\n");
            }
            for (int i3 = 0; i3 < this.points.length; ++i3) {
                int n2 = this.transitions[i2 * this.points.length + i3];
                if (n2 == -1) continue;
                int n3 = this.points[i3];
                int n4 = i3 + 1 < this.points.length ? this.points[i3 + 1] - 1 : this.maxInterval;
                stringBuilder.append(" ");
                Automaton.appendCharString(n3, stringBuilder);
                if (n3 != n4) {
                    stringBuilder.append("-");
                    Automaton.appendCharString(n4, stringBuilder);
                }
                stringBuilder.append(" -> ").append(n2).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isAccept(int n2) {
        return this.accept[n2];
    }

    public final int getInitialState() {
        return this.initial;
    }

    final int getCharClass(int n2) {
        return Operations.findIndex(n2, this.points);
    }

    public RunAutomaton(Automaton automaton, int n2, boolean bl, int n3) {
        int n4;
        int n5;
        this.maxInterval = n2;
        this.automaton = automaton = Operations.determinize(automaton, n3);
        this.points = automaton.getStartPoints();
        this.initial = 0;
        this.size = Math.max(1, automaton.getNumStates());
        this.accept = new boolean[this.size];
        this.transitions = new int[this.size * this.points.length];
        Arrays.fill(this.transitions, -1);
        for (n5 = 0; n5 < this.size; ++n5) {
            this.accept[n5] = automaton.isAccept(n5);
            for (n4 = 0; n4 < this.points.length; ++n4) {
                int n6 = automaton.step(n5, this.points[n4]);
                assert (n6 == -1 || n6 < this.size);
                this.transitions[n5 * this.points.length + n4] = n6;
            }
        }
        if (bl) {
            this.classmap = new int[n2 + 1];
            n5 = 0;
            for (n4 = 0; n4 <= n2; ++n4) {
                if (n5 + 1 >= this.points.length || n4 == this.points[n5 + 1]) {
                    // empty if block
                }
                this.classmap[n4] = ++n5;
            }
        } else {
            this.classmap = null;
        }
    }

    public final int step(int n2, int n3) {
        if (this.classmap == null) {
            return this.transitions[n2 * this.points.length + this.getCharClass(n3)];
        }
        return this.transitions[n2 * this.points.length + this.classmap[n3]];
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.initial;
        n3 = 31 * n3 + this.maxInterval;
        n3 = 31 * n3 + this.points.length;
        n3 = 31 * n3 + this.size;
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RunAutomaton runAutomaton = (RunAutomaton)object;
        if (this.initial != runAutomaton.initial) {
            return false;
        }
        if (this.maxInterval != runAutomaton.maxInterval) {
            return false;
        }
        if (this.size != runAutomaton.size) {
            return false;
        }
        if (!Arrays.equals(this.points, runAutomaton.points)) {
            return false;
        }
        if (!Arrays.equals(this.accept, runAutomaton.accept)) {
            return false;
        }
        return Arrays.equals(this.transitions, runAutomaton.transitions);
    }
}

