/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.fst.a;

public final class ByteSequenceOutputs
extends a<BytesRef> {
    private static final BytesRef NO_OUTPUT = new BytesRef();
    private static final ByteSequenceOutputs singleton = new ByteSequenceOutputs();
    private static final long BASE_NUM_BYTES = RamUsageEstimator.shallowSizeOf(NO_OUTPUT);

    private ByteSequenceOutputs() {
    }

    public static ByteSequenceOutputs getSingleton() {
        return singleton;
    }

    @Override
    public BytesRef common(BytesRef bytesRef, BytesRef bytesRef2) {
        assert (bytesRef != null);
        assert (bytesRef2 != null);
        int n2 = bytesRef.offset;
        int n3 = bytesRef2.offset;
        int n4 = n2 + Math.min(bytesRef.length, bytesRef2.length);
        while (n2 < n4 && bytesRef.bytes[n2] == bytesRef2.bytes[n3]) {
            ++n2;
            ++n3;
        }
        if (n2 == bytesRef.offset) {
            return NO_OUTPUT;
        }
        if (n2 == bytesRef.offset + bytesRef.length) {
            return bytesRef;
        }
        if (n3 == bytesRef2.offset + bytesRef2.length) {
            return bytesRef2;
        }
        return new BytesRef(bytesRef.bytes, bytesRef.offset, n2 - bytesRef.offset);
    }

    @Override
    public BytesRef subtract(BytesRef bytesRef, BytesRef bytesRef2) {
        assert (bytesRef != null);
        assert (bytesRef2 != null);
        if (bytesRef2 == NO_OUTPUT) {
            return bytesRef;
        }
        assert (StringHelper.startsWith(bytesRef, bytesRef2));
        if (bytesRef2.length == bytesRef.length) {
            return NO_OUTPUT;
        }
        assert (bytesRef2.length < bytesRef.length) : "inc.length=" + bytesRef2.length + " vs output.length=" + bytesRef.length;
        assert (bytesRef2.length > 0);
        return new BytesRef(bytesRef.bytes, bytesRef.offset + bytesRef2.length, bytesRef.length - bytesRef2.length);
    }

    @Override
    public BytesRef add(BytesRef bytesRef, BytesRef bytesRef2) {
        assert (bytesRef != null);
        assert (bytesRef2 != null);
        if (bytesRef == NO_OUTPUT) {
            return bytesRef2;
        }
        if (bytesRef2 == NO_OUTPUT) {
            return bytesRef;
        }
        assert (bytesRef.length > 0);
        assert (bytesRef2.length > 0);
        BytesRef bytesRef3 = new BytesRef(bytesRef.length + bytesRef2.length);
        System.arraycopy(bytesRef.bytes, bytesRef.offset, bytesRef3.bytes, 0, bytesRef.length);
        System.arraycopy(bytesRef2.bytes, bytesRef2.offset, bytesRef3.bytes, bytesRef.length, bytesRef2.length);
        bytesRef3.length = bytesRef.length + bytesRef2.length;
        return bytesRef3;
    }

    @Override
    public void write(BytesRef bytesRef, DataOutput dataOutput) throws IOException {
        assert (bytesRef != null);
        dataOutput.writeVInt(bytesRef.length);
        dataOutput.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
    }

    @Override
    public BytesRef read(DataInput dataInput) throws IOException {
        int n2 = dataInput.readVInt();
        if (n2 == 0) {
            return NO_OUTPUT;
        }
        BytesRef bytesRef = new BytesRef(n2);
        dataInput.readBytes(bytesRef.bytes, 0, n2);
        bytesRef.length = n2;
        return bytesRef;
    }

    @Override
    public void skipOutput(DataInput dataInput) throws IOException {
        int n2 = dataInput.readVInt();
        if (n2 != 0) {
            dataInput.skipBytes(n2);
        }
    }

    @Override
    public BytesRef getNoOutput() {
        return NO_OUTPUT;
    }

    @Override
    public long ramBytesUsed(BytesRef bytesRef) {
        return BASE_NUM_BYTES + RamUsageEstimator.sizeOf(bytesRef.bytes);
    }

    public String toString() {
        return "ByteSequenceOutputs";
    }
}

