/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.PackedInts;

abstract class AbstractBlockPackedWriter {
    protected DataOutput out;
    protected final long[] values;
    protected byte[] blocks;
    protected int off;
    protected long ord;
    protected boolean finished;

    static void writeVLong(DataOutput dataOutput, long l2) throws IOException {
        int n2 = 0;
        while ((l2 & 0xFFFFFFFFFFFFFF80L) != 0L && n2++ < 8) {
            dataOutput.writeByte((byte)(l2 & 0x7FL | 0x80L));
            l2 >>>= 7;
        }
        dataOutput.writeByte((byte)l2);
    }

    public AbstractBlockPackedWriter(DataOutput dataOutput, int n2) {
        PackedInts.checkBlockSize(n2, 64, 0x8000000);
        this.reset(dataOutput);
        this.values = new long[n2];
    }

    public void reset(DataOutput dataOutput) {
        assert (dataOutput != null);
        this.out = dataOutput;
        this.off = 0;
        this.ord = 0L;
        this.finished = false;
    }

    private void checkNotFinished() {
        if (this.finished) {
            throw new IllegalStateException("Already finished");
        }
    }

    public void add(long l2) throws IOException {
        this.checkNotFinished();
        if (this.off == this.values.length) {
            this.flush();
        }
        this.values[this.off++] = l2;
        ++this.ord;
    }

    public void finish() throws IOException {
        this.checkNotFinished();
        if (this.off > 0) {
            this.flush();
        }
        this.finished = true;
    }

    protected abstract void flush() throws IOException;

    protected final void writeValues(int n2) throws IOException {
        PackedInts.b b2 = PackedInts.getEncoder(PackedInts.Format.PACKED, 2, n2);
        int n3 = this.values.length / b2.byteValueCount();
        int n4 = b2.byteBlockCount() * n3;
        if (this.blocks == null || this.blocks.length < n4) {
            this.blocks = new byte[n4];
        }
        if (this.off < this.values.length) {
            Arrays.fill(this.values, this.off, this.values.length, 0L);
        }
        b2.encode(this.values, 0, this.blocks, 0, n3);
        int n5 = (int)PackedInts.Format.PACKED.byteCount(2, this.off, n2);
        this.out.writeBytes(this.blocks, n5);
    }
}

