/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;
import org.apache.lucene.util.packed.PackedInts;

abstract class AbstractPagedMutable<T extends AbstractPagedMutable<T>>
extends LongValues
implements a {
    final long size;
    final int pageShift;
    final int pageMask;
    final PackedInts.Mutable[] subMutables;
    final int bitsPerValue;

    AbstractPagedMutable(int n2, long l2, int n3) {
        this.bitsPerValue = n2;
        this.size = l2;
        this.pageShift = PackedInts.checkBlockSize(n3, 64, 0x40000000);
        this.pageMask = n3 - 1;
        int n4 = PackedInts.numBlocks(l2, n3);
        this.subMutables = new PackedInts.Mutable[n4];
    }

    protected final void fillPages() {
        int n2 = PackedInts.numBlocks(this.size, this.pageSize());
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 == n2 - 1 ? this.lastPageSize(this.size) : this.pageSize();
            this.subMutables[i2] = this.newMutable(n3, this.bitsPerValue);
        }
    }

    protected abstract PackedInts.Mutable newMutable(int var1, int var2);

    final int lastPageSize(long l2) {
        int n2 = this.indexInPage(l2);
        return n2 == 0 ? this.pageSize() : n2;
    }

    final int pageSize() {
        return this.pageMask + 1;
    }

    public final long size() {
        return this.size;
    }

    final int pageIndex(long l2) {
        return (int)(l2 >>> this.pageShift);
    }

    final int indexInPage(long l2) {
        return (int)l2 & this.pageMask;
    }

    @Override
    public final long get(long l2) {
        assert (l2 >= 0L && l2 < this.size);
        int n2 = this.pageIndex(l2);
        int n3 = this.indexInPage(l2);
        return this.subMutables[n2].get(n3);
    }

    public final void set(long l2, long l3) {
        assert (l2 >= 0L && l2 < this.size);
        int n2 = this.pageIndex(l2);
        int n3 = this.indexInPage(l2);
        this.subMutables[n2].set(n3, l3);
    }

    protected long baseRamBytesUsed() {
        return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_REF + 8 + 12;
    }

    @Override
    public long ramBytesUsed() {
        long l2 = RamUsageEstimator.alignObjectSize(this.baseRamBytesUsed());
        l2 += RamUsageEstimator.alignObjectSize(RamUsageEstimator.shallowSizeOf(this.subMutables));
        for (PackedInts.Mutable mutable : this.subMutables) {
            l2 += mutable.ramBytesUsed();
        }
        return l2;
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    protected abstract T newUnfilledCopy(long var1);

    public final T resize(long l2) {
        T t2 = this.newUnfilledCopy(l2);
        int n2 = Math.min(((AbstractPagedMutable)t2).subMutables.length, this.subMutables.length);
        long[] lArray = new long[1024];
        for (int i2 = 0; i2 < ((AbstractPagedMutable)t2).subMutables.length; ++i2) {
            int n3 = i2 == ((AbstractPagedMutable)t2).subMutables.length - 1 ? this.lastPageSize(l2) : this.pageSize();
            int n4 = i2 < n2 ? this.subMutables[i2].getBitsPerValue() : this.bitsPerValue;
            ((AbstractPagedMutable)t2).subMutables[i2] = this.newMutable(n3, n4);
            if (i2 >= n2) continue;
            int n5 = Math.min(n3, this.subMutables[i2].size());
            PackedInts.copy((PackedInts.Reader)this.subMutables[i2], 0, ((AbstractPagedMutable)t2).subMutables[i2], 0, n5, lArray);
        }
        return t2;
    }

    public final T grow(long l2) {
        assert (l2 >= 0L);
        if (l2 <= this.size()) {
            AbstractPagedMutable abstractPagedMutable = this;
            return (T)abstractPagedMutable;
        }
        long l3 = l2 >>> 3;
        if (l3 < 3L) {
            l3 = 3L;
        }
        long l4 = l2 + l3;
        return this.resize(l4);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(size=" + this.size() + ",pageSize=" + this.pageSize() + ")";
    }
}

