/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

final class Direct16
extends PackedInts.MutableImpl {
    final short[] values;

    Direct16(int n2) {
        super(n2, 16);
        this.values = new short[n2];
    }

    Direct16(int n2, DataInput dataInput, int n3) throws IOException {
        this(n3);
        int n4;
        for (n4 = 0; n4 < n3; ++n4) {
            this.values[n4] = dataInput.readShort();
        }
        n4 = (int)(PackedInts.Format.PACKED.byteCount(n2, n3, 16) - 2L * (long)n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            dataInput.readByte();
        }
    }

    @Override
    public long get(int n2) {
        return (long)this.values[n2] & 0xFFFFL;
    }

    @Override
    public void set(int n2, long l2) {
        this.values[n2] = (short)l2;
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(this.values);
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, (short)0);
    }

    @Override
    public int get(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = Math.min(this.valueCount - n2, n4);
        int n6 = n2;
        int n7 = n3;
        int n8 = n2 + n5;
        while (n6 < n8) {
            lArray[n7] = (long)this.values[n6] & 0xFFFFL;
            ++n6;
            ++n7;
        }
        return n5;
    }

    @Override
    public int set(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = Math.min(this.valueCount - n2, n4);
        int n6 = n2;
        int n7 = n3;
        int n8 = n2 + n5;
        while (n6 < n8) {
            this.values[n6] = (short)lArray[n7];
            ++n6;
            ++n7;
        }
        return n5;
    }

    @Override
    public void fill(int n2, int n3, long l2) {
        assert (l2 == (l2 & 0xFFFFL));
        Arrays.fill(this.values, n2, n3, (short)l2);
    }
}

