/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

final class Direct64
extends PackedInts.MutableImpl {
    final long[] values;

    Direct64(int n2) {
        super(n2, 64);
        this.values = new long[n2];
    }

    Direct64(int n2, DataInput dataInput, int n3) throws IOException {
        this(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.values[i2] = dataInput.readLong();
        }
    }

    @Override
    public long get(int n2) {
        return this.values[n2];
    }

    @Override
    public void set(int n2, long l2) {
        this.values[n2] = l2;
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(this.values);
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, 0L);
    }

    @Override
    public int get(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = Math.min(this.valueCount - n2, n4);
        System.arraycopy(this.values, n2, lArray, n3, n5);
        return n5;
    }

    @Override
    public int set(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = Math.min(this.valueCount - n2, n4);
        System.arraycopy(lArray, n3, this.values, n2, n5);
        return n5;
    }

    @Override
    public void fill(int n2, int n3, long l2) {
        Arrays.fill(this.values, n2, n3, l2);
    }
}

