/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.packed.PackedInts;

final class DirectPacked64SingleBlockReader
extends PackedInts.ReaderImpl {
    private final IndexInput in;
    private final int bitsPerValue;
    private final long startPointer;
    private final int valuesPerBlock;
    private final long mask;

    DirectPacked64SingleBlockReader(int n2, int n3, IndexInput indexInput) {
        super(n3);
        this.in = indexInput;
        this.bitsPerValue = n2;
        this.startPointer = indexInput.getFilePointer();
        this.valuesPerBlock = 64 / n2;
        this.mask = -1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long get(int n2) {
        int n3 = n2 / this.valuesPerBlock;
        long l2 = (long)n3 << 3;
        try {
            this.in.seek(this.startPointer + l2);
            long l3 = this.in.readLong();
            int n4 = n2 % this.valuesPerBlock;
            return l3 >>> n4 * this.bitsPerValue & this.mask;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("failed", iOException);
        }
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }
}

