/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.packed.PackedInts;

class DirectPackedReader
extends PackedInts.ReaderImpl {
    final IndexInput in;
    final int bitsPerValue;
    final long startPointer;
    final long valueMask;

    DirectPackedReader(int n2, int n3, IndexInput indexInput) {
        super(n3);
        this.in = indexInput;
        this.bitsPerValue = n2;
        this.startPointer = indexInput.getFilePointer();
        this.valueMask = n2 == 64 ? -1L : (1L << n2) - 1L;
    }

    @Override
    public long get(int n2) {
        long l2 = (long)n2 * (long)this.bitsPerValue;
        long l3 = l2 >>> 3;
        try {
            long l4;
            this.in.seek(this.startPointer + l3);
            int n3 = (int)(l2 & 7L);
            int n4 = n3 + this.bitsPerValue + 7 & 0xFFFFFFF8;
            int n5 = n4 - n3 - this.bitsPerValue;
            switch (n4 >>> 3) {
                case 1: {
                    l4 = this.in.readByte();
                    break;
                }
                case 2: {
                    l4 = this.in.readShort();
                    break;
                }
                case 3: {
                    l4 = (long)this.in.readShort() << 8 | (long)this.in.readByte() & 0xFFL;
                    break;
                }
                case 4: {
                    l4 = this.in.readInt();
                    break;
                }
                case 5: {
                    l4 = (long)this.in.readInt() << 8 | (long)this.in.readByte() & 0xFFL;
                    break;
                }
                case 6: {
                    l4 = (long)this.in.readInt() << 16 | (long)this.in.readShort() & 0xFFFFL;
                    break;
                }
                case 7: {
                    l4 = (long)this.in.readInt() << 24 | ((long)this.in.readShort() & 0xFFFFL) << 8 | (long)this.in.readByte() & 0xFFL;
                    break;
                }
                case 8: {
                    l4 = this.in.readLong();
                    break;
                }
                case 9: {
                    l4 = this.in.readLong() << 8 - n5 | ((long)this.in.readByte() & 0xFFL) >>> n5;
                    n5 = 0;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("bitsPerValue too large: " + this.bitsPerValue));
                }
            }
            return l4 >>> n5 & this.valueMask;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }
}

