/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;
import org.apache.lucene.util.packed.DeltaPackedLongValues;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class MonotonicLongValues
extends DeltaPackedLongValues {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MonotonicLongValues.class);
    final float[] averages;

    MonotonicLongValues(int n2, int n3, PackedInts.Reader[] readerArray, long[] lArray, float[] fArray, long l2, long l3) {
        super(n2, n3, readerArray, lArray, l2, l3);
        assert (readerArray.length == fArray.length);
        this.averages = fArray;
    }

    @Override
    long get(int n2, int n3) {
        return MonotonicBlockPackedReader.expected(this.mins[n2], this.averages[n2], n3) + this.values[n2].get(n3);
    }

    @Override
    int decodeBlock(int n2, long[] lArray) {
        int n3 = super.decodeBlock(n2, lArray);
        float f2 = this.averages[n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            lArray[n4] = lArray[n4] + MonotonicBlockPackedReader.expected(0L, f2, i2);
        }
        return n3;
    }

    static class Builder
    extends DeltaPackedLongValues.Builder {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Builder.class);
        float[] averages;

        Builder(int n2, float f2) {
            super(n2, f2);
            this.averages = new float[this.values.length];
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.averages);
        }

        @Override
        long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public MonotonicLongValues build() {
            this.finish();
            this.pending = null;
            a[] aArray = Arrays.copyOf(this.values, this.valuesOff);
            long[] lArray = Arrays.copyOf(this.mins, this.valuesOff);
            float[] fArray = Arrays.copyOf(this.averages, this.valuesOff);
            long l2 = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(aArray) + RamUsageEstimator.sizeOf(lArray) + RamUsageEstimator.sizeOf(fArray);
            return new MonotonicLongValues(this.pageShift, this.pageMask, (PackedInts.Reader[])aArray, lArray, fArray, this.size, l2);
        }

        @Override
        void pack(long[] lArray, int n2, int n3, float f2) {
            float f3 = n2 == 1 ? 0.0f : (float)(lArray[n2 - 1] - lArray[0]) / (float)(n2 - 1);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = i2;
                lArray[n4] = lArray[n4] - MonotonicBlockPackedReader.expected(0L, f3, i2);
            }
            super.pack(lArray, n2, n3, f2);
            this.averages[n3] = f3;
        }

        @Override
        void grow(int n2) {
            super.grow(n2);
            this.ramBytesUsed -= RamUsageEstimator.sizeOf(this.averages);
            this.averages = Arrays.copyOf(this.averages, n2);
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.averages);
        }
    }
}

