/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

final class Packed16ThreeBlocks
extends PackedInts.MutableImpl {
    final short[] blocks;

    Packed16ThreeBlocks(int n2) {
        super(n2, 48);
        if (n2 > 0x2AAAAAAA) {
            throw new ArrayIndexOutOfBoundsException("MAX_SIZE exceeded");
        }
        this.blocks = new short[n2 * 3];
    }

    Packed16ThreeBlocks(int n2, DataInput dataInput, int n3) throws IOException {
        this(n3);
        int n4;
        for (n4 = 0; n4 < 3 * n3; ++n4) {
            this.blocks[n4] = dataInput.readShort();
        }
        n4 = (int)(PackedInts.Format.PACKED.byteCount(n2, n3, 48) - 3L * (long)n3 * 2L);
        for (int i2 = 0; i2 < n4; ++i2) {
            dataInput.readByte();
        }
    }

    @Override
    public long get(int n2) {
        int n3 = n2 * 3;
        return ((long)this.blocks[n3] & 0xFFFFL) << 32 | ((long)this.blocks[n3 + 1] & 0xFFFFL) << 16 | (long)this.blocks[n3 + 2] & 0xFFFFL;
    }

    @Override
    public int get(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = Math.min(this.valueCount - n2, n4);
        int n6 = (n2 + n5) * 3;
        for (int i2 = n2 * 3; i2 < n6; i2 += 3) {
            lArray[n3++] = ((long)this.blocks[i2] & 0xFFFFL) << 32 | ((long)this.blocks[i2 + 1] & 0xFFFFL) << 16 | (long)this.blocks[i2 + 2] & 0xFFFFL;
        }
        return n5;
    }

    @Override
    public void set(int n2, long l2) {
        int n3 = n2 * 3;
        this.blocks[n3] = (short)(l2 >>> 32);
        this.blocks[n3 + 1] = (short)(l2 >>> 16);
        this.blocks[n3 + 2] = (short)l2;
    }

    @Override
    public int set(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = Math.min(this.valueCount - n2, n4);
        int n6 = n2 * 3;
        int n7 = n3 + n5;
        for (int i2 = n3; i2 < n7; ++i2) {
            long l2 = lArray[i2];
            this.blocks[n6++] = (short)(l2 >>> 32);
            this.blocks[n6++] = (short)(l2 >>> 16);
            this.blocks[n6++] = (short)l2;
        }
        return n5;
    }

    @Override
    public void fill(int n2, int n3, long l2) {
        short s2 = (short)(l2 >>> 32);
        short s3 = (short)(l2 >>> 16);
        short s4 = (short)l2;
        int n4 = n3 * 3;
        for (int i2 = n2 * 3; i2 < n4; i2 += 3) {
            this.blocks[i2] = s2;
            this.blocks[i2 + 1] = s3;
            this.blocks[i2 + 2] = s4;
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.blocks, (short)0);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(this.blocks);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(bitsPerValue=" + this.bitsPerValue + ",size=" + this.size() + ",blocks=" + this.blocks.length + ")";
    }
}

