/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

final class Packed8ThreeBlocks
extends PackedInts.MutableImpl {
    final byte[] blocks;

    Packed8ThreeBlocks(int n2) {
        super(n2, 24);
        if (n2 > 0x2AAAAAAA) {
            throw new ArrayIndexOutOfBoundsException("MAX_SIZE exceeded");
        }
        this.blocks = new byte[n2 * 3];
    }

    Packed8ThreeBlocks(int n2, DataInput dataInput, int n3) throws IOException {
        this(n3);
        dataInput.readBytes(this.blocks, 0, 3 * n3);
        int n4 = (int)(PackedInts.Format.PACKED.byteCount(n2, n3, 24) - 3L * (long)n3 * 1L);
        for (int i2 = 0; i2 < n4; ++i2) {
            dataInput.readByte();
        }
    }

    @Override
    public long get(int n2) {
        int n3 = n2 * 3;
        return ((long)this.blocks[n3] & 0xFFL) << 16 | ((long)this.blocks[n3 + 1] & 0xFFL) << 8 | (long)this.blocks[n3 + 2] & 0xFFL;
    }

    @Override
    public int get(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = Math.min(this.valueCount - n2, n4);
        int n6 = (n2 + n5) * 3;
        for (int i2 = n2 * 3; i2 < n6; i2 += 3) {
            lArray[n3++] = ((long)this.blocks[i2] & 0xFFL) << 16 | ((long)this.blocks[i2 + 1] & 0xFFL) << 8 | (long)this.blocks[i2 + 2] & 0xFFL;
        }
        return n5;
    }

    @Override
    public void set(int n2, long l2) {
        int n3 = n2 * 3;
        this.blocks[n3] = (byte)(l2 >>> 16);
        this.blocks[n3 + 1] = (byte)(l2 >>> 8);
        this.blocks[n3 + 2] = (byte)l2;
    }

    @Override
    public int set(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = Math.min(this.valueCount - n2, n4);
        int n6 = n2 * 3;
        int n7 = n3 + n5;
        for (int i2 = n3; i2 < n7; ++i2) {
            long l2 = lArray[i2];
            this.blocks[n6++] = (byte)(l2 >>> 16);
            this.blocks[n6++] = (byte)(l2 >>> 8);
            this.blocks[n6++] = (byte)l2;
        }
        return n5;
    }

    @Override
    public void fill(int n2, int n3, long l2) {
        byte by = (byte)(l2 >>> 16);
        byte by2 = (byte)(l2 >>> 8);
        byte by3 = (byte)l2;
        int n4 = n3 * 3;
        for (int i2 = n2 * 3; i2 < n4; i2 += 3) {
            this.blocks[i2] = by;
            this.blocks[i2 + 1] = by2;
            this.blocks[i2 + 2] = by3;
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.blocks, (byte)0);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(this.blocks);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(bitsPerValue=" + this.bitsPerValue + ",size=" + this.size() + ",blocks=" + this.blocks.length + ")";
    }
}

