/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;
import org.apache.lucene.util.packed.DeltaPackedLongValues;
import org.apache.lucene.util.packed.MonotonicLongValues;
import org.apache.lucene.util.packed.PackedInts;

public class PackedLongValues
extends LongValues
implements a {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(PackedLongValues.class);
    final PackedInts.Reader[] values;
    final int pageShift;
    final int pageMask;
    private final long size;
    private final long ramBytesUsed;

    public static Builder packedBuilder(int n2, float f2) {
        return new Builder(n2, f2);
    }

    public static Builder packedBuilder(float f2) {
        return PackedLongValues.packedBuilder(1024, f2);
    }

    public static Builder deltaPackedBuilder(int n2, float f2) {
        return new DeltaPackedLongValues.Builder(n2, f2);
    }

    public static Builder deltaPackedBuilder(float f2) {
        return PackedLongValues.deltaPackedBuilder(1024, f2);
    }

    public static Builder monotonicBuilder(int n2, float f2) {
        return new MonotonicLongValues.Builder(n2, f2);
    }

    public static Builder monotonicBuilder(float f2) {
        return PackedLongValues.monotonicBuilder(1024, f2);
    }

    PackedLongValues(int n2, int n3, PackedInts.Reader[] readerArray, long l2, long l3) {
        this.pageShift = n2;
        this.pageMask = n3;
        this.values = readerArray;
        this.size = l2;
        this.ramBytesUsed = l3;
    }

    public final long size() {
        return this.size;
    }

    int decodeBlock(int n2, long[] lArray) {
        PackedInts.Reader reader = this.values[n2];
        int n3 = reader.size();
        for (int i2 = 0; i2 < n3; i2 += reader.get(i2, lArray, i2, n3 - i2)) {
        }
        return n3;
    }

    long get(int n2, int n3) {
        return this.values[n2].get(n3);
    }

    @Override
    public final long get(long l2) {
        assert (l2 >= 0L && l2 < this.size());
        int n2 = (int)(l2 >> this.pageShift);
        int n3 = (int)(l2 & (long)this.pageMask);
        return this.get(n2, n3);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public static class Builder
    implements a {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Builder.class);
        final int pageShift;
        final int pageMask;
        final float acceptableOverheadRatio;
        long[] pending;
        long size;
        PackedInts.Reader[] values;
        long ramBytesUsed;
        int valuesOff;
        int pendingOff;

        Builder(int n2, float f2) {
            this.pageShift = PackedInts.checkBlockSize(n2, 64, 0x100000);
            this.pageMask = n2 - 1;
            this.acceptableOverheadRatio = f2;
            this.values = new PackedInts.Reader[16];
            this.pending = new long[n2];
            this.valuesOff = 0;
            this.pendingOff = 0;
            this.size = 0L;
            this.ramBytesUsed = this.baseRamBytesUsed() + RamUsageEstimator.sizeOf(this.pending) + RamUsageEstimator.shallowSizeOf(this.values);
        }

        public PackedLongValues build() {
            this.finish();
            this.pending = null;
            a[] aArray = Arrays.copyOf(this.values, this.valuesOff);
            long l2 = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(aArray);
            return new PackedLongValues(this.pageShift, this.pageMask, (PackedInts.Reader[])aArray, this.size, l2);
        }

        long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public final long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        @Override
        public Collection<a> getChildResources() {
            return Collections.emptyList();
        }

        public final long size() {
            return this.size;
        }

        public Builder add(long l2) {
            if (this.pending == null) {
                throw new IllegalStateException("Cannot be reused after build()");
            }
            if (this.pendingOff == this.pending.length) {
                if (this.values.length == this.valuesOff) {
                    int n2 = ArrayUtil.oversize(this.valuesOff + 1, 8);
                    this.grow(n2);
                }
                this.pack();
            }
            this.pending[this.pendingOff++] = l2;
            ++this.size;
            return this;
        }

        final void finish() {
            if (this.pendingOff > 0) {
                if (this.values.length == this.valuesOff) {
                    this.grow(this.valuesOff + 1);
                }
                this.pack();
            }
        }

        private void pack() {
            this.pack(this.pending, this.pendingOff, this.valuesOff, this.acceptableOverheadRatio);
            this.ramBytesUsed += this.values[this.valuesOff].ramBytesUsed();
            ++this.valuesOff;
            this.pendingOff = 0;
        }

        void pack(long[] lArray, int n2, int n3, float f2) {
            int n4;
            assert (n2 > 0);
            long l2 = lArray[0];
            long l3 = lArray[0];
            for (n4 = 1; n4 < n2; ++n4) {
                l2 = Math.min(l2, lArray[n4]);
                l3 = Math.max(l3, lArray[n4]);
            }
            if (l2 == 0L && l3 == 0L) {
                this.values[n3] = new PackedInts.NullReader(n2);
            } else {
                n4 = l2 < 0L ? 64 : PackedInts.bitsRequired(l3);
                PackedInts.Mutable mutable = PackedInts.getMutable(n2, n4, f2);
                for (int i2 = 0; i2 < n2; i2 += mutable.set(i2, lArray, i2, n2 - i2)) {
                }
                this.values[n3] = mutable;
            }
        }

        void grow(int n2) {
            this.ramBytesUsed -= RamUsageEstimator.shallowSizeOf(this.values);
            this.values = Arrays.copyOf(this.values, n2);
            this.ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.values);
        }
    }

    public final class Iterator {
        final long[] currentValues;
        int vOff;
        int pOff;
        int currentCount;

        Iterator() {
            this.currentValues = new long[PackedLongValues.this.pageMask + 1];
            this.pOff = 0;
            this.vOff = 0;
            this.fillBlock();
        }

        private void fillBlock() {
            if (this.vOff == PackedLongValues.this.values.length) {
                this.currentCount = 0;
            } else {
                this.currentCount = PackedLongValues.this.decodeBlock(this.vOff, this.currentValues);
                assert (this.currentCount > 0);
            }
        }

        public final boolean hasNext() {
            return this.pOff < this.currentCount;
        }

        public final long next() {
            assert (this.hasNext());
            long l2 = this.currentValues[this.pOff++];
            if (this.pOff == this.currentCount) {
                ++this.vOff;
                this.pOff = 0;
                this.fillBlock();
            }
            return l2;
        }
    }
}

