/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.audio;

import com.netease.yidun.sdk.antispam.AntispamRequester;
import com.netease.yidun.sdk.antispam.audio.callback.v4.AudioCallback;
import com.netease.yidun.sdk.antispam.audio.callback.v4.request.AudioCallbackV4Request;
import com.netease.yidun.sdk.antispam.audio.callback.v4.response.AudioCallbackV4Response;
import com.netease.yidun.sdk.antispam.audio.check.async.v4.request.AudioAsyncCheckRequest;
import com.netease.yidun.sdk.antispam.audio.check.async.v4.response.AudioAsyncCheckResponse;
import com.netease.yidun.sdk.antispam.audio.check.sync.v2.request.AudioSyncCheckRequest;
import com.netease.yidun.sdk.antispam.audio.check.sync.v2.response.AudioSyncCheckResponse;
import com.netease.yidun.sdk.antispam.audio.feedback.v1.request.AudioFeedbackRequest;
import com.netease.yidun.sdk.antispam.audio.feedback.v1.response.AudioFeedbackResponse;
import com.netease.yidun.sdk.antispam.audio.query.v3.request.AudioQueryV3Request;
import com.netease.yidun.sdk.antispam.audio.query.v3.response.AudioQueryV3Response;
import com.netease.yidun.sdk.core.utils.AssertUtils;

public class AudioClient {
    private AntispamRequester requester;

    public AudioClient(AntispamRequester requester) {
        AssertUtils.notNull((Object)requester, (String)"requester can not be null");
        this.requester = requester;
    }

    public AudioClient(AntispamRequester requester, AudioCallback audioCallback) {
        AssertUtils.notNull((Object)requester, (String)"requester can not be null");
        this.requester = requester;
        if (audioCallback != null) {
            if (audioCallback.getAntispamRequester() == null) {
                audioCallback.setAntispamRequester(requester);
            }
            audioCallback.start();
        }
    }

    public AudioSyncCheckResponse syncCheckAudio(AudioSyncCheckRequest request) {
        return this.requester.getAudioCheckClient().syncCheckAudio(request);
    }

    public AudioAsyncCheckResponse asyncCheckAudio(AudioAsyncCheckRequest request) {
        return this.requester.getAudioCheckClient().asyncCheckAudio(request);
    }

    public AudioFeedbackResponse feedback(AudioFeedbackRequest request) {
        return this.requester.getAudioCommonClient().feedback(request);
    }

    public AudioCallbackV4Response callback(AudioCallbackV4Request request) {
        return this.requester.getAudioCommonClient().callback(request);
    }

    public AudioQueryV3Response query(AudioQueryV3Request request) {
        return this.requester.getAudioCommonClient().query(request);
    }
}

