/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.enums;

import java.util.HashMap;
import java.util.Map;

public enum KeywordType {
    NORMAL(1, "\u666e\u901a\u8bcd"),
    COMBINE(2, "\u666e\u901a\u7ec4\u5408\u8bcd"),
    NORMAL_PINYIN(3, "\u666e\u901a\u62fc\u97f3\u8bcd");

    private static final Map<Integer, KeywordType> KEYWORD_TYPE_MAP;
    private int value;
    private String description;

    private KeywordType(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public static KeywordType valueOf(Integer value) {
        return KEYWORD_TYPE_MAP.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        KEYWORD_TYPE_MAP = new HashMap<Integer, KeywordType>();
        for (KeywordType type : KeywordType.values()) {
            KEYWORD_TYPE_MAP.put(type.getValue(), type);
        }
    }
}

