/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Page<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Page.class);
    private long count;
    private List<T> rows;

    public static <T> Page<T> fill(long count, List<T> rows) {
        return Page.builder().count(count).rows(rows).build();
    }

    public static <T> Page<T> empty() {
        return Page.fill(0L, new ArrayList());
    }

    public static <T> PageBuilder<T> builder() {
        return new PageBuilder();
    }

    public long getCount() {
        return this.count;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        List<T> this$rows = this.getRows();
        List<T> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        List<T> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }

    public String toString() {
        return "Page(count=" + this.getCount() + ", rows=" + this.getRows() + ")";
    }

    private Page() {
    }

    private Page(long count, List<T> rows) {
        this.count = count;
        this.rows = rows;
    }

    public static class PageBuilder<T> {
        private long count;
        private List<T> rows;

        PageBuilder() {
        }

        public PageBuilder<T> count(long count) {
            this.count = count;
            return this;
        }

        public PageBuilder<T> rows(List<T> rows) {
            this.rows = rows;
            return this;
        }

        public Page<T> build() {
            return new Page(this.count, this.rows);
        }

        public String toString() {
            return "Page.PageBuilder(count=" + this.count + ", rows=" + this.rows + ")";
        }
    }
}

