/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam;

import com.netease.yidun.sdk.antispam.AntispamClient;
import com.netease.yidun.sdk.antispam.AntispamRequesterRegistry;
import com.netease.yidun.sdk.antispam.audio.AudioCheckClient;
import com.netease.yidun.sdk.antispam.audio.AudioCommonClient;
import com.netease.yidun.sdk.antispam.crawler.CrawlerCommonClient;
import com.netease.yidun.sdk.antispam.crawler.CrawlerSubmitClient;
import com.netease.yidun.sdk.antispam.digitalbook.v2.DigitalBookCheckClient;
import com.netease.yidun.sdk.antispam.digitalbook.v2.DigitalBookQueryClient;
import com.netease.yidun.sdk.antispam.file.v2.FileSolutionCallbackClient;
import com.netease.yidun.sdk.antispam.file.v2.FileSolutionCheckClient;
import com.netease.yidun.sdk.antispam.grammarfix.GrammarfixCommonClient;
import com.netease.yidun.sdk.antispam.image.v5.ImageCheckClient;
import com.netease.yidun.sdk.antispam.image.v5.ImageCommonClient;
import com.netease.yidun.sdk.antispam.keyword.KeywordCommonClient;
import com.netease.yidun.sdk.antispam.list.ListCommonClient;
import com.netease.yidun.sdk.antispam.liveaudio.LiveAudioCheckClient;
import com.netease.yidun.sdk.antispam.liveaudio.LiveAudioCommonClient;
import com.netease.yidun.sdk.antispam.livevideo.LiveVideoCheckClient;
import com.netease.yidun.sdk.antispam.livevideo.LiveVideoCommonClient;
import com.netease.yidun.sdk.antispam.livevideosolution.LiveVideoSolutionCheckClient;
import com.netease.yidun.sdk.antispam.livevideosolution.LiveVideoSolutionCommonClient;
import com.netease.yidun.sdk.antispam.media.v2.MediaCheckClient;
import com.netease.yidun.sdk.antispam.media.v2.MediaQueryClient;
import com.netease.yidun.sdk.antispam.pretreatment.PretreatmentCommonClient;
import com.netease.yidun.sdk.antispam.report.v1.ReportCheckClient;
import com.netease.yidun.sdk.antispam.report.v1.ReportQueryClient;
import com.netease.yidun.sdk.antispam.stream.v1.AigcStreamCommonClient;
import com.netease.yidun.sdk.antispam.stream.v1.AigcStreamPushClient;
import com.netease.yidun.sdk.antispam.text.TextCheckClient;
import com.netease.yidun.sdk.antispam.text.TextCommonClient;
import com.netease.yidun.sdk.antispam.video.VideoCheckClient;
import com.netease.yidun.sdk.antispam.video.VideoCommonClient;
import com.netease.yidun.sdk.antispam.videosolution.VideoSolutionCheckClient;
import com.netease.yidun.sdk.antispam.videosolution.VideoSolutionCommonClient;
import com.netease.yidun.sdk.core.auth.Credentials;
import com.netease.yidun.sdk.core.client.ClientProfile;
import com.netease.yidun.sdk.core.http.HttpClientConfig;
import com.netease.yidun.sdk.core.utils.AssertUtils;
import com.netease.yidun.sdk.openapi.OpenApiClient;
import java.util.concurrent.ConcurrentHashMap;

public class AntispamRequester {
    private ClientProfile clientProfile;
    private ConcurrentHashMap<String, Object> clientMap = new ConcurrentHashMap();

    public static AntispamRequester getInstance(String secretId, String secretKey) {
        return AntispamRequesterRegistry.register(secretId, secretKey);
    }

    public static AntispamRequester getInstance(ClientProfile clientProfile) {
        return AntispamRequesterRegistry.register(clientProfile);
    }

    public AntispamRequester(String secretId, String secretKey) {
        AssertUtils.notBlank((String)secretId, (String)"secretId can not be null or empty");
        AssertUtils.notBlank((String)secretKey, (String)"secretKey can not be null or empty");
        this.clientProfile = AntispamRequester.createDefaultProfile(secretId, secretKey);
    }

    public AntispamRequester(ClientProfile clientProfile) {
        AssertUtils.notNull((Object)clientProfile, (String)"clientProfile can not be null");
        AssertUtils.notNull((Object)clientProfile.credentials(), (String)"credentials can not be null");
        AssertUtils.notBlank((String)clientProfile.credentials().secretId(), (String)"secretId can not be null or empty");
        AssertUtils.notBlank((String)clientProfile.credentials().secretKey(), (String)"secretKey can not be null or empty");
        this.clientProfile = clientProfile;
    }

    public ClientProfile getClientProfile() {
        return this.clientProfile;
    }

    public static ClientProfile createDefaultProfile(String secretId, String secretKey) {
        ClientProfile clientProfile = ClientProfile.defaultProfile((Credentials)new Credentials(secretId, secretKey));
        HttpClientConfig clientConfig = new HttpClientConfig();
        clientConfig.setMaxConnectionCountPerRoute(100);
        clientProfile.setHttpClientConfig(clientConfig);
        return clientProfile;
    }

    public ImageCheckClient getImageCheckClient() {
        return this.createIfAbsent(ImageCheckClient.class);
    }

    public ImageCommonClient getImageCommonClient() {
        return this.createIfAbsent(ImageCommonClient.class);
    }

    public AudioCheckClient getAudioCheckClient() {
        return this.createIfAbsent(AudioCheckClient.class);
    }

    public AudioCommonClient getAudioCommonClient() {
        return this.createIfAbsent(AudioCommonClient.class);
    }

    public VideoCheckClient getVideoCheckClient() {
        return this.createIfAbsent(VideoCheckClient.class);
    }

    public VideoCommonClient getVideoCommonClient() {
        return this.createIfAbsent(VideoCommonClient.class);
    }

    public VideoSolutionCheckClient getVideoSolutionCheckClient() {
        return this.createIfAbsent(VideoSolutionCheckClient.class);
    }

    public VideoSolutionCommonClient getVideoSolutionCommonClient() {
        return this.createIfAbsent(VideoSolutionCommonClient.class);
    }

    public LiveAudioCheckClient getLiveAudioCheckClient() {
        return this.createIfAbsent(LiveAudioCheckClient.class);
    }

    public LiveAudioCommonClient getLiveAudioCommonClient() {
        return this.createIfAbsent(LiveAudioCommonClient.class);
    }

    public LiveVideoCheckClient getLiveVideoCheckClient() {
        return this.createIfAbsent(LiveVideoCheckClient.class);
    }

    public LiveVideoCommonClient getLiveVideoCommonClient() {
        return this.createIfAbsent(LiveVideoCommonClient.class);
    }

    public LiveVideoSolutionCheckClient getLiveVideoSolutionCheckClient() {
        return this.createIfAbsent(LiveVideoSolutionCheckClient.class);
    }

    public LiveVideoSolutionCommonClient getLiveVideoSolutionCommonClient() {
        return this.createIfAbsent(LiveVideoSolutionCommonClient.class);
    }

    public TextCheckClient getTextCheckClient() {
        return this.createIfAbsent(TextCheckClient.class);
    }

    public TextCommonClient getTextCommonClient() {
        return this.createIfAbsent(TextCommonClient.class);
    }

    public MediaCheckClient getMediaCheckClient() {
        return this.createIfAbsent(MediaCheckClient.class);
    }

    public MediaQueryClient getMediaQueryClient() {
        return this.createIfAbsent(MediaQueryClient.class);
    }

    public AigcStreamPushClient getAigcStreamPushClient() {
        return this.createIfAbsent(AigcStreamPushClient.class);
    }

    public AigcStreamCommonClient getAigcStreamCommonClient() {
        return this.createIfAbsent(AigcStreamCommonClient.class);
    }

    public ReportCheckClient getReportCheckClient() {
        return this.createIfAbsent(ReportCheckClient.class);
    }

    public ReportQueryClient getReportQueryClient() {
        return this.createIfAbsent(ReportQueryClient.class);
    }

    public DigitalBookCheckClient getDigitalBookCheckClient() {
        return this.createIfAbsent(DigitalBookCheckClient.class);
    }

    public DigitalBookQueryClient getDigitalBookQueryClient() {
        return this.createIfAbsent(DigitalBookQueryClient.class);
    }

    public FileSolutionCheckClient getFileSolutionCheckClient() {
        return this.createIfAbsent(FileSolutionCheckClient.class);
    }

    public FileSolutionCallbackClient getFileSolutionQueryClient() {
        return this.createIfAbsent(FileSolutionCallbackClient.class);
    }

    public CrawlerCommonClient getCrawlerCommonClient() {
        return this.createIfAbsent(CrawlerCommonClient.class);
    }

    public CrawlerSubmitClient getCrawlerSubmitClient() {
        return this.createIfAbsent(CrawlerSubmitClient.class);
    }

    public GrammarfixCommonClient getGrammarfixCommonClient() {
        return this.createIfAbsent(GrammarfixCommonClient.class);
    }

    public KeywordCommonClient getKeywordCommonClient() {
        return this.createIfAbsent(KeywordCommonClient.class);
    }

    public ListCommonClient getListCommonClient() {
        return this.createIfAbsent(ListCommonClient.class);
    }

    public PretreatmentCommonClient getPretreatmentCommonClient() {
        return this.createIfAbsent(PretreatmentCommonClient.class);
    }

    public OpenApiClient getOpenApiClient() {
        return this.createIfAbsent(OpenApiClient.class);
    }

    private <T extends AntispamClient> T createIfAbsent(Class<T> clazz) {
        String name = clazz.getName();
        Object client = this.clientMap.get(name);
        if (client != null) {
            return (T)((AntispamClient)client);
        }
        return (T)((AntispamClient)this.clientMap.computeIfAbsent(name, k -> {
            try {
                return clazz.getDeclaredConstructor(ClientProfile.class).newInstance(this.clientProfile);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }
}

