/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam;

import com.netease.yidun.sdk.antispam.AntispamRequester;
import com.netease.yidun.sdk.core.client.ClientProfile;
import com.netease.yidun.sdk.core.utils.AssertUtils;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class AntispamRequesterRegistry {
    private static final Map<String, AntispamRequester> requesterMap = new ConcurrentHashMap<String, AntispamRequester>();

    public static AntispamRequester register(String secretId, String secretKey) {
        AssertUtils.notBlank((String)secretId, (String)"secretId can not be null or empty");
        String key = secretId;
        return Optional.ofNullable(requesterMap.get(key)).orElseGet(() -> requesterMap.computeIfAbsent(key, k -> new AntispamRequester(secretId, secretKey)));
    }

    public static AntispamRequester register(ClientProfile clientProfile) {
        AssertUtils.notNull((Object)clientProfile, (String)"clientProfile can not be null");
        AssertUtils.notNull((Object)clientProfile.credentials(), (String)"credentials can not be null");
        AssertUtils.notBlank((String)clientProfile.credentials().secretId(), (String)"secretId can not be null or empty");
        String key = clientProfile.credentials().secretId();
        return Optional.ofNullable(requesterMap.get(key)).orElseGet(() -> requesterMap.computeIfAbsent(key, k -> new AntispamRequester(clientProfile)));
    }
}

