/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam;

import com.netease.yidun.sdk.antispam.AntispamRequester;
import com.netease.yidun.sdk.antispam.callback.AbstractCallbackHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CallbackRegistry {
    private static final Map<String, AbstractCallbackHandler> callbackMap = new ConcurrentHashMap<String, AbstractCallbackHandler>();

    public static void register(AntispamRequester requester, AbstractCallbackHandler ... callbacks) {
        if (callbacks != null && callbacks.length > 0) {
            for (AbstractCallbackHandler callback : callbacks) {
                String key;
                if (callback.getAntispamRequester() == null) {
                    callback.setAntispamRequester(requester);
                }
                if (callbackMap.get(key = callback.getAntispamRequester().getClientProfile().getCredentials().getSecretId() + "," + callback.getProfile().getBusinessId() + "," + callback.getClass().getName()) != null) continue;
                callbackMap.computeIfAbsent(key, k -> {
                    callback.start();
                    return callback;
                });
            }
        }
    }

    public static Collection<AbstractCallbackHandler> all() {
        return Collections.unmodifiableCollection(callbackMap.values());
    }
}

