/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam;

import com.netease.yidun.sdk.antispam.AntispamRequester;
import com.netease.yidun.sdk.core.utils.AssertUtils;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ClientRegistry {
    private static final Map<String, Object> clientMap = new ConcurrentHashMap<String, Object>();

    public static <T> T register(AntispamRequester antispamRequester, Class<T> clazz) {
        AssertUtils.notNull((Object)antispamRequester, (String)"AntispamRequester can not be null");
        String key = antispamRequester.getClientProfile().getCredentials().getSecretId() + "," + clazz.getName();
        return (T)Optional.ofNullable(clientMap.get(key)).orElseGet(() -> clientMap.computeIfAbsent(key, k -> {
            try {
                return clazz.getDeclaredConstructor(AntispamRequester.class).newInstance(antispamRequester);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }
}

