/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.callback;

import com.netease.yidun.sdk.antispam.AntispamRequester;
import com.netease.yidun.sdk.antispam.callback.CallbackContext;
import com.netease.yidun.sdk.antispam.callback.CallbackProfile;
import com.netease.yidun.sdk.core.utils.AssertUtils;
import com.netease.yidun.sdk.core.utils.UUIDUtils;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCallbackHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCallbackHandler.class);
    private static final Integer PARK_TIME_MILLS = 100;
    private static final Integer LONG_PARK_TIME_MILLS = 1000;
    private static final Long WASTE_COUNT_THRESHOLD = 20L;
    protected ThreadPoolExecutor callbackExecutor;
    private CallbackProfile profile;
    protected AntispamRequester antispamRequester;
    private volatile Boolean isClose = false;

    public AbstractCallbackHandler(AntispamRequester antispamRequester) {
        this(antispamRequester, new CallbackProfile());
    }

    public AbstractCallbackHandler(AntispamRequester antispamRequester, String businessId) {
        this(antispamRequester, new CallbackProfile(businessId));
    }

    public AbstractCallbackHandler(AntispamRequester antispamRequester, CallbackProfile profile) {
        AssertUtils.notNull((Object)profile, (String)"profile can not be null");
        AssertUtils.notNull((Object)profile.getConcurrency(), (String)"concurrency can not be null");
        this.antispamRequester = antispamRequester;
        this.profile = profile;
    }

    public CallbackProfile getProfile() {
        return this.profile;
    }

    public void start() {
        AssertUtils.notNull((Object)this.profile.getConcurrency(), (String)"concurrency can not be null");
        AssertUtils.notNull((Object)this.antispamRequester, (String)"antispamRequester can not be null");
        this.callbackExecutor = new ThreadPoolExecutor((int)this.profile.getConcurrency(), (int)this.profile.getConcurrency(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger sn = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Callback-Thread-" + this.sn.getAndIncrement());
            }
        });
        for (int i = 0; i < this.profile.getConcurrency(); ++i) {
            this.callbackExecutor.execute(() -> {
                long wasteCount = 0L;
                String requestId = this.generateRequestId();
                CallbackContext context = new CallbackContext();
                while (!this.isClose.booleanValue()) {
                    List<T> callbackData = null;
                    try {
                        callbackData = this.requestCallback(this.profile.getBusinessId(), requestId);
                    }
                    catch (Exception e) {
                        log.error("fetch callback data fails, retry!", (Throwable)e);
                    }
                    try {
                        if (callbackData != null && callbackData.size() > 0) {
                            this.handle(callbackData);
                            context.setRequestId(requestId);
                            this.postHandle(context);
                            wasteCount = 0L;
                            requestId = this.generateRequestId();
                            continue;
                        }
                        if (++wasteCount > WASTE_COUNT_THRESHOLD) {
                            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(LONG_PARK_TIME_MILLS.intValue()));
                            continue;
                        }
                        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(PARK_TIME_MILLS.intValue()));
                    }
                    catch (Exception e) {
                        log.error("handle callback data fails !", (Throwable)e);
                    }
                }
            });
        }
    }

    public void setAntispamRequester(AntispamRequester antispamRequester) {
        this.antispamRequester = antispamRequester;
    }

    public AntispamRequester getAntispamRequester() {
        return this.antispamRequester;
    }

    public void close() throws InterruptedException {
        this.isClose = true;
        this.callbackExecutor.shutdown();
        if (!this.callbackExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            this.callbackExecutor.shutdownNow();
        }
    }

    protected abstract List<T> requestCallback(String var1, String var2);

    public abstract void handle(List<T> var1);

    protected void postHandle(CallbackContext context) {
    }

    protected String generateRequestId() {
        return UUIDUtils.randomUUID();
    }
}

