/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.crawler.v3.submit.request;

import com.netease.yidun.sdk.antispam.crawler.v3.submit.response.CrawlerResourceSubmitV3Response;
import com.netease.yidun.sdk.core.http.HttpMethodEnum;
import com.netease.yidun.sdk.core.request.PostFormRequest;
import com.netease.yidun.sdk.core.utils.CollectionUtils;
import com.netease.yidun.sdk.core.utils.StringHashMap;
import com.netease.yidun.sdk.core.validation.limitation.Length;
import com.netease.yidun.sdk.core.validation.limitation.NotEmpty;
import com.netease.yidun.sdk.core.validation.limitation.NotNull;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CrawlerResourceSubmitV3Request
extends PostFormRequest<CrawlerResourceSubmitV3Response> {
    @Length(max=1024, message="url\u6700\u957f1024\u4e2a\u5b57\u7b26")
    @NotNull
    private String url;
    @Length(max=128, message="dataId\u6700\u957f128\u4e2a\u5b57\u7b26")
    @NotNull
    private String dataId;
    @Length(max=512, message="callback\u6700\u957f512\u4e2a\u5b57\u7b26")
    private String callback;
    @NotEmpty(message="checkFlags\u4e0d\u80fd\u4e3a\u7a7a")
    private List<Integer> checkFlags;
    @Length(max=1024, message="callbackUrl\u6700\u957f1024\u4e2a\u5b57\u7b26")
    private String callbackUrl;
    @Length(max=64, message="siteName\u6700\u957f64\u4e2a\u5b57\u7b26")
    private String siteName;
    private String content;
    private String config;
    private Set<Long> checkStrategyGroupIds;
    private String extension;
    private String account;

    public CrawlerResourceSubmitV3Request() {
        this.productCode = "crawler";
        this.uriPattern = "/v3/crawler/submit";
        this.method = HttpMethodEnum.POST;
        this.version = "v3.0";
    }

    protected Map<String, String> getCustomSignParams() {
        StringHashMap params = new StringHashMap();
        params.put("url", this.getUrl());
        params.put("dataId", this.getDataId());
        params.put("callback", this.getCallback());
        params.put("checkFlags", (String)Optional.ofNullable(this.getCheckFlags()).map(o -> o.stream().map(String::valueOf).collect(Collectors.joining(","))).orElse(null));
        params.put("callbackUrl", this.getCallbackUrl());
        params.put("siteName", this.getSiteName());
        params.put("content", this.getContent());
        params.put("config", this.getConfig());
        if (!CollectionUtils.isEmpty(this.checkStrategyGroupIds)) {
            params.put("checkStrategyGroupIds", this.checkStrategyGroupIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        params.put("extension", this.getExtension());
        params.put("account", this.getAccount());
        return params;
    }

    public static void main(String[] args) {
        CrawlerResourceSubmitV3Request request = new CrawlerResourceSubmitV3Request();
        request.setCheckFlags(Arrays.asList(1, 2, 3));
        String orElse = Optional.ofNullable(request.getCheckFlags()).map(o -> o.stream().map(String::valueOf).collect(Collectors.joining(","))).orElse(null);
        String join = String.join((CharSequence)",", Arrays.asList(new CharSequence[0]));
        System.out.println(orElse);
    }

    public Class<CrawlerResourceSubmitV3Response> getResponseClass() {
        return CrawlerResourceSubmitV3Response.class;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public List<Integer> getCheckFlags() {
        return this.checkFlags;
    }

    public void setCheckFlags(List<Integer> checkFlags) {
        this.checkFlags = checkFlags;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Set<Long> getCheckStrategyGroupIds() {
        return this.checkStrategyGroupIds;
    }

    public void setCheckStrategyGroupIds(Set<Long> checkStrategyGroupIds) {
        this.checkStrategyGroupIds = checkStrategyGroupIds;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String toString() {
        return "CrawlerResourceSubmitV3Request{url='" + this.url + '\'' + ", dataId='" + this.dataId + '\'' + ", callback='" + this.callback + '\'' + ", checkFlags=" + this.checkFlags + ", callbackUrl='" + this.callbackUrl + '\'' + ", siteName='" + this.siteName + '\'' + ", content='" + this.content + '\'' + ", config='" + this.config + '\'' + ", checkStrategyGroupIds=" + this.checkStrategyGroupIds + ", extension='" + this.extension + '\'' + ", account='" + this.account + '\'' + '}';
    }
}

