/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.label.cache;

import com.netease.yidun.sdk.antispam.AntispamRequester;
import com.netease.yidun.sdk.antispam.label.LabelClient;
import com.netease.yidun.sdk.antispam.label.cache.CacheProperty;
import com.netease.yidun.sdk.antispam.label.cache.LabelCacheItem;
import com.netease.yidun.sdk.antispam.label.query.request.LabelQueryRequest;
import com.netease.yidun.sdk.antispam.label.query.response.LabelQueryInfo;
import com.netease.yidun.sdk.antispam.label.query.response.LabelQueryResponse;
import com.netease.yidun.sdk.antispam.label.query.response.SubLabel;
import com.netease.yidun.sdk.core.client.ClientProfile;
import com.netease.yidun.sdk.core.response.CommonResponse;
import com.netease.yidun.sdk.core.utils.AssertUtils;
import com.netease.yidun.sdk.core.utils.CollectionUtils;
import com.netease.yidun.sdk.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelCache.class);
    private static volatile Map<String, LabelCacheItem> codeNameMap;
    private static volatile List<LabelClient> labelClients;
    private static final AtomicBoolean INITIALIZED;

    public static String getLabelName(String labelCode) {
        if (codeNameMap == null) {
            return null;
        }
        LabelCacheItem cacheItem = codeNameMap.get(labelCode);
        if (cacheItem == null) {
            return null;
        }
        return cacheItem.getName();
    }

    public static void initCache(ClientProfile clientProfile, LabelQueryRequest request) {
        AssertUtils.notNull((Object)clientProfile, (String)"clientProfile can not be null");
        ArrayList<ClientProfile> clientProfiles = new ArrayList<ClientProfile>(1);
        clientProfiles.add(clientProfile);
        CacheProperty cacheProperty = new CacheProperty();
        cacheProperty.setRefreshIntervalMinute(60);
        LabelCache.initCache(clientProfiles, request, cacheProperty);
    }

    public static void initCache(List<ClientProfile> clientProfiles, LabelQueryRequest request, CacheProperty cacheProperty) {
        AssertUtils.notNull((Object)((Object)request), (String)"request can not be null");
        AssertUtils.notEmpty(clientProfiles, (String)"clientProfiles can not be null or empty");
        AssertUtils.notNull((Object)cacheProperty, (String)"cacheProperty can not be null");
        boolean initSuccess = INITIALIZED.compareAndSet(false, true);
        if (!initSuccess) {
            LOGGER.warn("label cache has been initialized");
            return;
        }
        codeNameMap = new ConcurrentHashMap<String, LabelCacheItem>();
        labelClients = clientProfiles.stream().map(profile -> LabelClient.getInstance(AntispamRequester.getInstance(profile))).collect(Collectors.toList());
        LabelCache.refreshCache(request, cacheProperty);
    }

    private static void refreshCache(LabelQueryRequest request, CacheProperty cacheProperty) {
        ScheduledThreadPoolExecutor cacheRefresherExec = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("label-cache-refresher");
            thread.setDaemon(true);
            return thread;
        });
        cacheRefresherExec.scheduleWithFixedDelay(() -> {
            try {
                long currentTime = System.currentTimeMillis();
                boolean buildSuccess = LabelCache.buildCache(request, currentTime);
                if (buildSuccess) {
                    LabelCache.expireCache(currentTime);
                }
            }
            catch (Exception e) {
                LOGGER.error("refresh label cache error", (Throwable)e);
            }
        }, cacheProperty.getRefreshIntervalMinute().intValue(), cacheProperty.getRefreshIntervalMinute().intValue(), TimeUnit.MINUTES);
        LabelCache.buildCache(request, System.currentTimeMillis());
    }

    private static boolean buildCache(LabelQueryRequest request, long currentTime) {
        boolean success = true;
        for (LabelClient labelClient : labelClients) {
            LabelQueryResponse labelQueryResponse;
            try {
                labelQueryResponse = labelClient.queryLabel(request);
            }
            catch (Exception e) {
                LOGGER.error("query label for label cache error", (Throwable)e);
                success = false;
                continue;
            }
            if (labelQueryResponse == null || !Objects.equals(labelQueryResponse.getCode(), 200) || CollectionUtils.isEmpty(labelQueryResponse.getData())) {
                LOGGER.error("query label for label cache empty, response code {}, msg {}", Optional.ofNullable(labelQueryResponse).map(CommonResponse::getCode).orElse(null), Optional.ofNullable(labelQueryResponse).map(CommonResponse::getMsg).orElse(null));
                success = false;
                continue;
            }
            for (LabelQueryInfo labelQueryInfo : labelQueryResponse.getData()) {
                if (labelQueryInfo == null) continue;
                if (labelQueryInfo.getLabel() != null) {
                    LabelCache.putInCache(String.valueOf(labelQueryInfo.getLabel()), labelQueryInfo.getName(), currentTime);
                }
                LabelCache.recursiveSubLabels(labelQueryInfo.getSubLabels(), currentTime);
            }
        }
        return success;
    }

    private static void expireCache(long lastUpdateTime) {
        Iterator<Map.Entry<String, LabelCacheItem>> iterator = codeNameMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, LabelCacheItem> entry = iterator.next();
            if (entry.getValue().getUpdateTime() >= lastUpdateTime) continue;
            iterator.remove();
        }
    }

    private static void recursiveSubLabels(List<SubLabel> subLabels, long currentTime) {
        if (CollectionUtils.isEmpty(subLabels)) {
            return;
        }
        for (SubLabel subLabel : subLabels) {
            if (subLabel == null) continue;
            LabelCache.putInCache(subLabel.getCode(), subLabel.getName(), currentTime);
            LabelCache.recursiveSubLabels(subLabel.getSubLabels(), currentTime);
        }
    }

    private static void putInCache(String labelCode, String labelName, long currentTime) {
        if (StringUtils.isBlank((CharSequence)labelCode) || StringUtils.isBlank((CharSequence)labelName)) {
            return;
        }
        LabelCacheItem cacheItem = codeNameMap.putIfAbsent(labelCode, new LabelCacheItem(labelName, currentTime));
        if (cacheItem == null) {
            return;
        }
        if (!Objects.equals(cacheItem.getName(), labelName)) {
            cacheItem.setName(labelName);
        }
        cacheItem.setUpdateTime(currentTime);
    }

    static {
        INITIALIZED = new AtomicBoolean(false);
    }
}

