/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.label.query.request;

import com.netease.yidun.sdk.antispam.label.query.response.LabelQueryResponse;
import com.netease.yidun.sdk.core.http.HttpMethodEnum;
import com.netease.yidun.sdk.core.http.ProtocolEnum;
import com.netease.yidun.sdk.core.request.OpenApiGetRequest;
import com.netease.yidun.sdk.core.utils.StringUtils;
import java.util.List;
import java.util.Map;

public class LabelQueryRequest
extends OpenApiGetRequest<LabelQueryResponse> {
    private static final Integer DEFAULT_DEPTH = 2;
    @Deprecated
    private String clientId;
    private List<String> businessTypes;
    private String businessId;
    private Integer maxDepth = DEFAULT_DEPTH;
    private Boolean fetchClientLabel;

    public LabelQueryRequest() {
        this.productCode = "label";
        this.uriPattern = "/openapi/v2/antispam/label/query";
        this.domain = "openapi.dun.163.com";
        this.protocol = ProtocolEnum.HTTPS;
        this.method = HttpMethodEnum.GET;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<String> getBusinessTypes() {
        return this.businessTypes;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public Integer getMaxDepth() {
        return this.maxDepth;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setBusinessTypes(List<String> businessTypes) {
        this.businessTypes = businessTypes;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public void setMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public Boolean getFetchClientLabel() {
        return this.fetchClientLabel;
    }

    public void setFetchClientLabel(Boolean fetchClientLabel) {
        this.fetchClientLabel = fetchClientLabel;
    }

    protected Map<String, String> getCustomSignParams() {
        Map params = super.getCustomSignParams();
        params.put("clientId", this.clientId);
        params.put("businessId", this.businessId);
        params.put("fetchClientLabel", Boolean.TRUE.equals(this.fetchClientLabel) ? "true" : "false");
        params.put("maxDepth", String.valueOf(this.maxDepth));
        params.put("businessTypes", StringUtils.join(this.businessTypes, (String)","));
        return params;
    }

    public String toString() {
        return "LabelQueryRequest{clientId='" + this.clientId + '\'' + ", businessTypes=" + this.businessTypes + ", businessId='" + this.businessId + '\'' + ", fetchClientLabel='" + this.fetchClientLabel + '\'' + ", maxDepth=" + this.maxDepth + '}';
    }

    public Class<LabelQueryResponse> getResponseClass() {
        return LabelQueryResponse.class;
    }
}

