/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover;

import com.netease.yidun.sdk.antispam.recover.Recover;
import com.netease.yidun.sdk.antispam.recover.RecoverConfig;
import com.netease.yidun.sdk.antispam.recover.RecoverHandler;
import com.netease.yidun.sdk.antispam.recover.db.RecoverRepositoryReadHandler;
import com.netease.yidun.sdk.antispam.recover.db.asyn.DefaultRecoverAsyner;
import com.netease.yidun.sdk.antispam.recover.db.asyn.RecoverAsyner;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRecover<T>
implements Recover<T>,
RecoverRepositoryReadHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultRecover.class);
    private RecoverHandler<T> recoverHandler;
    private RecoverAsyner<T> recoverAsyner;
    private String dbName;
    private Class<T> clazz;
    private volatile boolean started = false;
    private Lock startLock = new ReentrantLock();
    private RecoverConfig recoverConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRecover(RecoverHandler<T> recoverHandler, String dbName, Class<T> clazz, RecoverConfig recoverConfig) {
        this.recoverConfig = recoverConfig;
        this.recoverHandler = recoverHandler;
        this.dbName = dbName;
        this.clazz = clazz;
        this.startLock.lock();
        try {
            if (!this.started) {
                this.recoverAsyner = new DefaultRecoverAsyner<T>(dbName, clazz, this, recoverConfig);
                this.recoverAsyner.start();
                this.started = true;
            }
        }
        finally {
            this.startLock.unlock();
        }
    }

    @Override
    public void recover(T data) {
        if (!this.started) {
            this.start();
        }
        this.recoverAsyner.asyn(data);
    }

    @Override
    public void recover(Collection<T> datas) {
        if (!this.started) {
            this.start();
        }
        for (T data : datas) {
            this.recover(data);
        }
    }

    @Override
    @Deprecated
    public void start() {
        if (!this.started) {
            this.startLock.lock();
            try {
                if (!this.started) {
                    this.recoverAsyner = new DefaultRecoverAsyner<T>(this.dbName, this.clazz, this, this.recoverConfig);
                    this.recoverAsyner.start();
                    this.started = true;
                }
            }
            finally {
                this.startLock.unlock();
            }
        }
    }

    @Override
    public void stop() {
        this.recoverAsyner.stop();
    }

    @Override
    public boolean handleRecover(T data) {
        boolean opRet;
        if (this.tryRecover(data)) {
            return true;
        }
        int count = 1;
        do {
            log.warn("dbName:{}, \u7b2c {} \u6b21\u5c1d\u8bd5\u6062\u590d\u6570\u636e\u5931\u8d25,\u6682\u505c\u6267\u884c {} s", new Object[]{this.dbName, count, this.recoverConfig.getRecoverFailRetryIntervalInSec()});
            try {
                TimeUnit.SECONDS.sleep(this.recoverConfig.getRecoverFailRetryIntervalInSec());
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
        } while (!(opRet = this.tryRecover(data)) && ++count <= this.recoverConfig.getRecoverThreshold());
        if (!opRet) {
            log.error("dbName:{}, \u6062\u590d\u6b21\u6570\u8fbe\u5230\u4e0a\u9650[{}]\u6b21\u4ecd\u5931\u8d25, data: {}", new Object[]{this.dbName, count, data});
        }
        log.info("dbName:{}, \u7b2c {} \u6b21\u5c1d\u8bd5\u6062\u590d\u6570\u636e, \u6700\u7ec8\u6267\u884c\u7ed3\u679c:{} \u7ee7\u7eed\u6062\u590d\u540e\u7eed\u6570\u636e", new Object[]{this.dbName, count, opRet});
        return opRet;
    }

    @Override
    public boolean tryRecover(T data) {
        boolean recovered = false;
        try {
            recovered = this.recoverHandler.tryRecover(data);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u6062\u590d\u5931\u8d25", (Throwable)e);
        }
        return recovered;
    }
}

