/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover;

import com.netease.yidun.sdk.antispam.recover.AbstractRequestRecoverHandler;
import com.netease.yidun.sdk.antispam.recover.FileRequestRecover;
import com.netease.yidun.sdk.antispam.recover.LifeCycle;
import com.netease.yidun.sdk.antispam.recover.RecoverConfig;
import com.netease.yidun.sdk.antispam.recover.RequestRecoverRegistry;
import com.netease.yidun.sdk.core.client.DefaultClient;
import com.netease.yidun.sdk.core.recover.RecoverMessage;
import com.netease.yidun.sdk.core.recover.RequestRecover;
import com.netease.yidun.sdk.core.response.BaseResponse;
import com.netease.yidun.sdk.core.utils.AssertUtils;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestRecover
implements RequestRecover,
LifeCycle {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final RequestRecoverRegistry requestRecoverRegistry;
    private static volatile DefaultRequestRecover requestRecover;

    private DefaultRequestRecover(RecoverConfig recoverConfig) {
        AssertUtils.notBlank((String)recoverConfig.getRecoverFileDir(), (String)"recoverFileDir should not be empty");
        this.requestRecoverRegistry = new RequestRecoverRegistry(recoverConfig);
    }

    public static DefaultRequestRecover createRecover(String recoverFileDir) {
        RecoverConfig recoverConfig = new RecoverConfig();
        recoverConfig.setRecoverFileDir(recoverFileDir);
        return DefaultRequestRecover.createRecover(recoverConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultRequestRecover createRecover(RecoverConfig recoverConfig) {
        if (requestRecover != null) return requestRecover;
        Class<DefaultRequestRecover> clazz = DefaultRequestRecover.class;
        synchronized (DefaultRequestRecover.class) {
            if (requestRecover != null) return requestRecover;
            requestRecover = new DefaultRequestRecover(recoverConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return requestRecover;
        }
    }

    public boolean isSupport(Class<?> responseClass) {
        return this.requestRecoverRegistry.getRecoverHandler(responseClass) != null;
    }

    public boolean doRecover(RecoverMessage message, Class<?> responseClass) {
        FileRequestRecover fileRequestRecover = this.requestRecoverRegistry.getRecover(responseClass);
        if (fileRequestRecover == null) {
            return false;
        }
        try {
            fileRequestRecover.recover(message);
            return true;
        }
        catch (Exception e) {
            log.error("recover request fails ", (Throwable)e);
            return false;
        }
    }

    public void registerRecover(List<Class<?>> responseClasses, String recoverName, DefaultClient client) {
        this.requestRecoverRegistry.registerRecover(responseClasses, recoverName, client);
    }

    public void registerRecoverHandler(AbstractRequestRecoverHandler handler) {
        this.requestRecoverRegistry.registerRecoverHandler(handler);
    }

    public <T extends BaseResponse> void registerFallback(T fallbackResponse) {
        this.requestRecoverRegistry.registerFallback(fallbackResponse);
    }

    public <T extends BaseResponse> T getFallbackResponse(Class<T> responseClass) {
        return this.requestRecoverRegistry.getFallback(responseClass);
    }

    @Override
    public void start() {
        this.requestRecoverRegistry.start();
    }

    @Override
    public void stop() {
        this.requestRecoverRegistry.stop();
    }
}

