/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover;

import com.google.gson.Gson;
import com.netease.yidun.sdk.antispam.recover.AbstractRequestRecoverHandler;
import com.netease.yidun.sdk.antispam.recover.RecoverConfig;
import com.netease.yidun.sdk.antispam.recover.RequestRecoverRegistry;
import com.netease.yidun.sdk.antispam.recover.WrapRecover;
import com.netease.yidun.sdk.core.client.Client;
import com.netease.yidun.sdk.core.client.DefaultClient;
import com.netease.yidun.sdk.core.recover.RecoverMessage;
import com.netease.yidun.sdk.core.request.BaseRequest;
import com.netease.yidun.sdk.core.response.BaseResponse;
import com.netease.yidun.sdk.core.utils.AssertUtils;
import com.netease.yidun.sdk.core.utils.StringUtils;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRequestRecover
extends WrapRecover<RecoverMessage> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Client> clientMap;
    private final Gson gson = new Gson();
    private final RequestRecoverRegistry registry;
    private final String dbFileName;

    private FileRequestRecover(RecoverConfig recoverConfig, String dbFileName, RequestRecoverRegistry registry) {
        super(recoverConfig, dbFileName);
        AssertUtils.notBlank((String)recoverConfig.getRecoverFileDir(), (String)"recoverFileDir should not be empty");
        this.clientMap = new ConcurrentHashMap<String, Client>();
        this.registry = registry;
        this.dbFileName = dbFileName;
    }

    public static FileRequestRecover createRecover(RecoverConfig recoverConfig, String dbFileName, RequestRecoverRegistry registry) {
        return new FileRequestRecover(recoverConfig, dbFileName, registry);
    }

    public void addClient(DefaultClient client) {
        String secretId = client.credentials().secretId();
        if (StringUtils.isBlank((CharSequence)secretId)) {
            return;
        }
        this.clientMap.putIfAbsent(secretId, (Client)client);
    }

    @Override
    public boolean tryRecover(RecoverMessage data) {
        BaseResponse response;
        BaseRequest request;
        try {
            Class<?> clazz = Class.forName(data.getClazz());
            request = (BaseRequest)this.gson.fromJson(data.getMessage(), clazz);
            request.setEnableRecover(false);
        }
        catch (Exception e) {
            log.error("recover message discard due to class not found or message invalid, class:{}, message:{}", new Object[]{data.getClazz(), data.getMessage(), e});
            return true;
        }
        Client client = this.clientMap.get(data.getSecretId());
        if (client == null) {
            log.error("recover message discard due to client not found, secretId:{}, message:{}", (Object)data.getSecretId(), (Object)data.getMessage());
            return true;
        }
        try {
            response = client.execute(request);
        }
        catch (Exception e) {
            log.warn("recover {} fail {}", (Object)this.dbFileName, (Object)e);
            return false;
        }
        AbstractRequestRecoverHandler handler = this.registry.getRecoverHandler(response.getClass());
        if (handler != null) {
            try {
                handler.handle(response);
            }
            catch (Exception e) {
                log.error("recover message handler error, message:{}", (Object)data.getMessage());
                return false;
            }
        } else {
            log.error("recover message discard due to request recover handler is not exist, message:{}", (Object)data.getMessage());
        }
        return true;
    }
}

