/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover;

import com.netease.yidun.sdk.core.utils.NetUtils;
import com.netease.yidun.sdk.core.utils.StringUtils;
import java.io.File;

public class RecoverConfig {
    public static final String RECOVER_FILE_SUFFIX = ".recover";
    public static final String RECOVER_ERROR_FILE_SUFFIX = ".error";
    private long recoverFailRetryIntervalInSec = 30L;
    private long initialDelayInSec = 180L;
    private String recoverFileDir;
    private String appName;
    private boolean ipIsolateEnable;
    private long recoverFileSizeLimitInMB = 20480L;
    private long clusterCleanIntervalInSec = 60L;
    private int recoverThreshold = 15;
    private int recoverLinesPerTime = 100;
    private boolean recoverFailAbortEnable = false;
    private int clusterRecoverPoolSize = 15;
    private final String localAddress = NetUtils.getLocalHost();
    private static final long ONE_MB_IN_BYTE = 0x100000L;

    public String getBasePath() {
        String dir = this.recoverFileDir;
        if (!this.recoverFileDir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        return StringUtils.isNotBlank((CharSequence)this.appName) ? dir + this.appName + File.separator : dir;
    }

    public String getRecoverFilePath(String dbName) {
        return this.ipIsolateEnable ? this.getBasePath() + String.format("%s_%s%s", this.localAddress, dbName, RECOVER_FILE_SUFFIX) : this.getBasePath() + String.format("%s%s", dbName, RECOVER_FILE_SUFFIX);
    }

    public String getRecoverErrorFilePath(String dbName) {
        return this.getBasePath() + dbName + RECOVER_ERROR_FILE_SUFFIX;
    }

    public String getRecoverLockFilePath() {
        return this.getBasePath() + "recovery.lock";
    }

    public boolean fileSizeLimitEnable() {
        return this.recoverFileSizeLimitInMB > 0L;
    }

    public long getRecoverFileSizeLimitInByte() {
        return this.recoverFileSizeLimitInMB * 0x100000L;
    }

    public long getRecoverFailRetryIntervalInSec() {
        return this.recoverFailRetryIntervalInSec;
    }

    public long getInitialDelayInSec() {
        return this.initialDelayInSec;
    }

    public String getRecoverFileDir() {
        return this.recoverFileDir;
    }

    public String getAppName() {
        return this.appName;
    }

    public boolean isIpIsolateEnable() {
        return this.ipIsolateEnable;
    }

    public long getRecoverFileSizeLimitInMB() {
        return this.recoverFileSizeLimitInMB;
    }

    public long getClusterCleanIntervalInSec() {
        return this.clusterCleanIntervalInSec;
    }

    public int getRecoverThreshold() {
        return this.recoverThreshold;
    }

    public int getRecoverLinesPerTime() {
        return this.recoverLinesPerTime;
    }

    public boolean isRecoverFailAbortEnable() {
        return this.recoverFailAbortEnable;
    }

    public int getClusterRecoverPoolSize() {
        return this.clusterRecoverPoolSize;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setRecoverFailRetryIntervalInSec(long recoverFailRetryIntervalInSec) {
        this.recoverFailRetryIntervalInSec = recoverFailRetryIntervalInSec;
    }

    public void setInitialDelayInSec(long initialDelayInSec) {
        this.initialDelayInSec = initialDelayInSec;
    }

    public void setRecoverFileDir(String recoverFileDir) {
        this.recoverFileDir = recoverFileDir;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setIpIsolateEnable(boolean ipIsolateEnable) {
        this.ipIsolateEnable = ipIsolateEnable;
    }

    public void setRecoverFileSizeLimitInMB(long recoverFileSizeLimitInMB) {
        this.recoverFileSizeLimitInMB = recoverFileSizeLimitInMB;
    }

    public void setClusterCleanIntervalInSec(long clusterCleanIntervalInSec) {
        this.clusterCleanIntervalInSec = clusterCleanIntervalInSec;
    }

    public void setRecoverThreshold(int recoverThreshold) {
        this.recoverThreshold = recoverThreshold;
    }

    public void setRecoverLinesPerTime(int recoverLinesPerTime) {
        this.recoverLinesPerTime = recoverLinesPerTime;
    }

    public void setRecoverFailAbortEnable(boolean recoverFailAbortEnable) {
        this.recoverFailAbortEnable = recoverFailAbortEnable;
    }

    public void setClusterRecoverPoolSize(int clusterRecoverPoolSize) {
        this.clusterRecoverPoolSize = clusterRecoverPoolSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecoverConfig)) {
            return false;
        }
        RecoverConfig other = (RecoverConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRecoverFailRetryIntervalInSec() != other.getRecoverFailRetryIntervalInSec()) {
            return false;
        }
        if (this.getInitialDelayInSec() != other.getInitialDelayInSec()) {
            return false;
        }
        String this$recoverFileDir = this.getRecoverFileDir();
        String other$recoverFileDir = other.getRecoverFileDir();
        if (this$recoverFileDir == null ? other$recoverFileDir != null : !this$recoverFileDir.equals(other$recoverFileDir)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        if (this.isIpIsolateEnable() != other.isIpIsolateEnable()) {
            return false;
        }
        if (this.getRecoverFileSizeLimitInMB() != other.getRecoverFileSizeLimitInMB()) {
            return false;
        }
        if (this.getClusterCleanIntervalInSec() != other.getClusterCleanIntervalInSec()) {
            return false;
        }
        if (this.getRecoverThreshold() != other.getRecoverThreshold()) {
            return false;
        }
        if (this.getRecoverLinesPerTime() != other.getRecoverLinesPerTime()) {
            return false;
        }
        if (this.isRecoverFailAbortEnable() != other.isRecoverFailAbortEnable()) {
            return false;
        }
        if (this.getClusterRecoverPoolSize() != other.getClusterRecoverPoolSize()) {
            return false;
        }
        String this$localAddress = this.getLocalAddress();
        String other$localAddress = other.getLocalAddress();
        return !(this$localAddress == null ? other$localAddress != null : !this$localAddress.equals(other$localAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecoverConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $recoverFailRetryIntervalInSec = this.getRecoverFailRetryIntervalInSec();
        result = result * 59 + (int)($recoverFailRetryIntervalInSec >>> 32 ^ $recoverFailRetryIntervalInSec);
        long $initialDelayInSec = this.getInitialDelayInSec();
        result = result * 59 + (int)($initialDelayInSec >>> 32 ^ $initialDelayInSec);
        String $recoverFileDir = this.getRecoverFileDir();
        result = result * 59 + ($recoverFileDir == null ? 43 : $recoverFileDir.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        result = result * 59 + (this.isIpIsolateEnable() ? 79 : 97);
        long $recoverFileSizeLimitInMB = this.getRecoverFileSizeLimitInMB();
        result = result * 59 + (int)($recoverFileSizeLimitInMB >>> 32 ^ $recoverFileSizeLimitInMB);
        long $clusterCleanIntervalInSec = this.getClusterCleanIntervalInSec();
        result = result * 59 + (int)($clusterCleanIntervalInSec >>> 32 ^ $clusterCleanIntervalInSec);
        result = result * 59 + this.getRecoverThreshold();
        result = result * 59 + this.getRecoverLinesPerTime();
        result = result * 59 + (this.isRecoverFailAbortEnable() ? 79 : 97);
        result = result * 59 + this.getClusterRecoverPoolSize();
        String $localAddress = this.getLocalAddress();
        result = result * 59 + ($localAddress == null ? 43 : $localAddress.hashCode());
        return result;
    }

    public String toString() {
        return "RecoverConfig(recoverFailRetryIntervalInSec=" + this.getRecoverFailRetryIntervalInSec() + ", initialDelayInSec=" + this.getInitialDelayInSec() + ", recoverFileDir=" + this.getRecoverFileDir() + ", appName=" + this.getAppName() + ", ipIsolateEnable=" + this.isIpIsolateEnable() + ", recoverFileSizeLimitInMB=" + this.getRecoverFileSizeLimitInMB() + ", clusterCleanIntervalInSec=" + this.getClusterCleanIntervalInSec() + ", recoverThreshold=" + this.getRecoverThreshold() + ", recoverLinesPerTime=" + this.getRecoverLinesPerTime() + ", recoverFailAbortEnable=" + this.isRecoverFailAbortEnable() + ", clusterRecoverPoolSize=" + this.getClusterRecoverPoolSize() + ", localAddress=" + this.getLocalAddress() + ")";
    }
}

