/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover;

import com.netease.yidun.sdk.antispam.recover.db.file.ErrorRecoverFile;
import com.netease.yidun.sdk.antispam.recover.db.file.RecoverFile;
import com.netease.yidun.sdk.antispam.recover.db.file.RecoverFileHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RecoverRegistry {
    private static final Map<String, RecoverFileHandler> RECOVER_HANDLER_MAP = new ConcurrentHashMap<String, RecoverFileHandler>();
    private static final Map<String, RecoverFile> LOCAL_RECOVER_FILE_MAP = new ConcurrentHashMap<String, RecoverFile>();
    private static final List<ErrorRecoverFile> ERROR_RECOVER_FILE_LIST = new ArrayList<ErrorRecoverFile>();

    public static void register(String dbName, RecoverFile recoverFile, ErrorRecoverFile errorRecoverFile) {
        if (recoverFile == null || recoverFile.getRecoverFileHandler() == null || errorRecoverFile == null) {
            throw new IllegalArgumentException("Bad argument for RecoverRegistry");
        }
        RECOVER_HANDLER_MAP.put(dbName, recoverFile.getRecoverFileHandler());
        LOCAL_RECOVER_FILE_MAP.put(dbName, recoverFile);
        ERROR_RECOVER_FILE_LIST.add(errorRecoverFile);
    }

    public static RecoverFileHandler lookupHandler(String dbName) {
        return RECOVER_HANDLER_MAP.get(dbName);
    }

    public static RecoverFile lookupFile(String dbName) {
        return LOCAL_RECOVER_FILE_MAP.get(dbName);
    }

    public static List<ErrorRecoverFile> getErrorRecoverFileList() {
        return ERROR_RECOVER_FILE_LIST;
    }
}

