/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover;

import com.netease.yidun.sdk.antispam.recover.AbstractRequestRecoverHandler;
import com.netease.yidun.sdk.antispam.recover.FileRequestRecover;
import com.netease.yidun.sdk.antispam.recover.LifeCycle;
import com.netease.yidun.sdk.antispam.recover.RecoverConfig;
import com.netease.yidun.sdk.antispam.recover.recovery.RecoverManager;
import com.netease.yidun.sdk.core.client.DefaultClient;
import com.netease.yidun.sdk.core.exception.YidunSdkException;
import com.netease.yidun.sdk.core.response.BaseResponse;
import com.netease.yidun.sdk.core.response.CommonResponse;
import com.netease.yidun.sdk.core.utils.AssertUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RequestRecoverRegistry
implements LifeCycle {
    private final Map<Class<? extends BaseResponse>, BaseResponse> fallbackMap = new ConcurrentHashMap<Class<? extends BaseResponse>, BaseResponse>();
    private final Map<Class<?>, AbstractRequestRecoverHandler> handlerMap = new ConcurrentHashMap();
    private final Map<Class<?>, FileRequestRecover> recoverMap = new ConcurrentHashMap();
    private final RecoverConfig recoverConfig;
    private final RecoverManager recoverManager;
    private volatile Lock lock = new ReentrantLock();

    public RequestRecoverRegistry(RecoverConfig recoverConfig) {
        this.recoverConfig = recoverConfig;
        this.recoverManager = new RecoverManager(recoverConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRecover(List<Class<?>> responseClasses, String recoverName, DefaultClient client) {
        if (responseClasses == null || responseClasses.size() == 0) {
            return;
        }
        FileRequestRecover recover = this.recoverMap.get(responseClasses.get(0));
        if (recover == null) {
            this.lock.lock();
            try {
                recover = this.recoverMap.get(responseClasses.get(0));
                if (recover == null) {
                    recover = FileRequestRecover.createRecover(this.recoverConfig, recoverName, this);
                    for (Class<?> responseClass : responseClasses) {
                        this.recoverMap.put(responseClass, recover);
                    }
                    recover.start();
                    this.recoverManager.start();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        recover.addClient(client);
    }

    public FileRequestRecover getRecover(Class responseClass) {
        if (responseClass == null) {
            return null;
        }
        return this.recoverMap.get(responseClass);
    }

    public void registerRecoverHandler(AbstractRequestRecoverHandler handler) {
        AssertUtils.notNull((Object)handler, (String)"recoverHandler can not be null");
        Class<?> clazz = handler.getClass();
        while (clazz.getSuperclass() != null && clazz.getSuperclass() != AbstractRequestRecoverHandler.class) {
            clazz = clazz.getSuperclass();
        }
        if (clazz == Object.class) {
            throw new IllegalArgumentException("not support class type");
        }
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            try {
                Class responseClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                this.handlerMap.put(responseClass, handler);
                if (this.getFallback(responseClass) != null) {
                    return;
                }
                CommonResponse defaultFallback = (CommonResponse)responseClass.newInstance();
                defaultFallback.setCode(200);
                defaultFallback.setMsg("default fallback response");
                this.registerFallback(defaultFallback);
            }
            catch (Exception e) {
                throw new YidunSdkException((Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("not support class type");
        }
    }

    public AbstractRequestRecoverHandler getRecoverHandler(Class responseClass) {
        if (responseClass == null) {
            return null;
        }
        return this.handlerMap.get(responseClass);
    }

    public <T extends BaseResponse> void registerFallback(T fallbackResponse) {
        if (fallbackResponse == null) {
            return;
        }
        this.fallbackMap.put(fallbackResponse.getClass(), fallbackResponse);
    }

    public <T extends BaseResponse> T getFallback(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        BaseResponse fallbackResp = this.fallbackMap.get(clazz);
        if (fallbackResp == null) {
            return null;
        }
        return (T)fallbackResp;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.recoverMap.size() == 0) {
            return;
        }
        for (FileRequestRecover recover : this.recoverMap.values()) {
            recover.stop();
        }
        this.recoverManager.stop();
    }
}

